use strict;
use warnings;
use utf8;

use lib::abs "./../../lib";
use lib::abs "./../../services/v5";

use API::PSGI::SOAP;
use API::PSGI::Reports::XML;

my $soap_app = API::PSGI::SOAP->get_app;
my $reports_xml_app = API::PSGI::Reports::XML->get_app;

my $app = sub {
    my ($env) = @_;

    my @uri_components = split m{/}, $env->{REQUEST_URI};

    if ( @uri_components && $uri_components[-1] eq 'reports' ) {
        return $reports_xml_app->($env);
    }

    return $soap_app->($env);
};
