package API::Error::ToExceptionNotification;

use strict;
use warnings;
use utf8;

=pod

    $Id$

=head1 NAME

    API::Error::ToExceptionNotification

=head1 SYNOPSIS

    use API::Error::ToExceptionNotification qw/action_errors action_error action_warnings action_warning/;

    use Direct::Defect

    my $error = Direct::Defect->new(
        code => 123,
        text => "error happens",
        description => "Because you were naughty"
    );

    API::Service::AdGroups::Types::ActionResult->new({
        Id => "1111",
        Errors => [ action_error($error) ] # [ ExceptionNotification ]
    });

    API::Service::AdGroups::Types::ActionResult->new({
        Id => "1111",
        Errors => action_errors($error) # [ ExceptionNotification ]
    });

=head1 DESCRIPTION

    Для конвертации объектов ошибок и предупреждений в hash_ref для WSDL объекта
    ExceptionNotification используемого в ActionResults методов возвращающих
    ответ пообъектным списком

=head1 METHODS

=cut

use Exporter qw/import/;

our @EXPORT_OK = qw/action_errors action_error action_warnings/;

=head2 action_errors(@errors) -> [ Notifications ]

=cut

sub action_errors { [ map { action_error($_) } @_ ] }

=head2 action_error($error) -> [ Notification ]

=cut

sub action_error {
    my $error = shift or die "no error";
    return {
        Code => $error->code,
        Message => $error->text,
        $error->description ? (Details => $error->description) : ()
    };
}

=head2 action_warnings(@errors) -> [ Notifications ]

=cut

sub action_warnings { action_errors(@_) }

1;

__END__
