package API::Service::AdImages::ResultSet::Delete;
use Direct::Modern;

use parent 'API::Service::ResultSet::Delete';

=pod

    $Id$

=head1 NAME

    API::Service::AdImages::ResultSet::Delete

=head1 SYNOPSIS

=head1 DESCRIPTION

=head1 METHODS

=cut

use API::Error::ToExceptionNotification qw/action_errors action_warnings/;

sub _id_from_object {
    my ($self, $object) = @_;
    return $object->{AdImageHash};
}

sub id_item_to_xml {
    my ($self, $id, $item) = @_;
    my $r = {};

    # you either die young by error, or live long to have an id
    die 'no id or errors' unless $id || $item->has_errors;

    # if there is a error we hiddin id even if we have one
    $r->{AdImageHash} = $id if $id && !$item->has_errors;
    $r->{Errors} = action_errors($item->list_errors) if $item->has_errors;
    $r->{Warnings} = action_warnings($item->list_warnings) if $item->has_warnings;

    return $r;
}

1;

__END__
