package API::Service::Campaigns::GetRequest;

use strict;
use warnings;
use utf8;

use Mouse;

use API::Service::Campaigns::Types qw/get_type_structures_names/;

extends 'API::Service::Request::Get::GetWithType';

has types => (is => 'ro', isa => 'ArrayRef', default => sub { get_type_structures_names() });

=head2 set_selection_attribute

    Добавляет в SelectionCriteria новые условия поиска
    Так как для кампаний SelectionCriteria не обязателен а начальные условия поиска задать нужно,
    чтоб в выборку не попали чужие кампании или не поддерживаемые типы кампаний

=cut

sub set_selection_attribute {
    my $self = shift;
    my $criteria_name = shift;
    my $criteria_values = shift;
    $self->selection_criteria->{$criteria_name} = $criteria_values;
    return 1;
}

__PACKAGE__->meta->make_immutable();

1;

__END__
