package API::Service::Campaigns::ResultSet;

use Direct::Modern;

=pod

    $Id$

=head1 NAME

    API::Service::Campaigns::ResultSet

=head1 SYNOPSIS

    my $rs = API::Service::Campaigns::ResultSet->new( @some_objects_or_ids );

    ...

    return { MethodResults => $rs->prepare_for_xml };

=head1 DESCRIPTION

    Класс для формирования ответов API-сервиса Campaigns

=head1 METHODS

=head2 prepare_for_xml($error)

    Вернет состояние ResultSet-а, готовое для сериализации

=cut

use base qw/API::Service::ResultSet::Base/;

use Scalar::Util qw/ blessed /;

use API::Service::Campaigns::ResultSetItem;

sub item_class { 'API::Service::Campaigns::ResultSetItem' }

sub _is_object {
    my ( $self, $object ) = @_;

    return blessed( $object ) ? 1 : 0;
}

sub _id_from_object {
    my ( $self, $object ) = @_;

    return $self->_is_object( $object ) ? $object->id : $object->{Id}; # undef
}

sub prepare_for_xml {
    my $self = shift;
    return [
        map {
            $self->id_item_to_xml(
                $self->_id_from_object($_->object), # NB: maybe undef here?
                $_
            )
        } $self->list
    ];
}

1;
