package API::Service::CampaignsExt;

use Direct::Modern;

use Yandex::I18n;

use API::Service::Campaigns::Types qw/get_type_structures_names convert_types_to_external/;

use API::Service::Campaigns::ConvertSubs qw/convert_settings_to_external/;

use Direct::Campaigns::ContentPromotion;
use Direct::Errors::Messages;

use base qw/API::Service::Campaigns/;

my $BUSINESS_CLASS_BY_TYPE = { map {$_->supported_type => $_} qw/
        Direct::Campaigns::Dynamic
        Direct::Campaigns::Performance
        Direct::Campaigns::MobileContent
        Direct::Campaigns::Text
        Direct::Campaigns::CpmBanner
        Direct::Campaigns::ContentPromotion/ };

=head2 get_business_logic_class_by_type

    Переопределение get_business_logic_class_by_type родительского класса с добавлением туда ContentPromotion

=cut

sub get_business_logic_class_by_type {
    my ($self, $type) = @_;
    return $BUSINESS_CLASS_BY_TYPE->{$type};
}

=head2 _process_pay_for_install

    Переопределение _process_pay_for_install родительского класса,
    чтобы заглушка не срабатывала и возвращалась стратегия PAY_FOR_INSTALL вместо UNKNOWN

=cut

sub _process_pay_for_install {
}

=head2 converter($method, $type)

    Переопределение метода из родительского класса, чтобы вызывать с service_name родительского класса,
    то есть Campaigns вместо CampaignsExt

=cut

sub converter($$){
    my ($self, $type) = @_;
    local $self->{_service_name} = 'Campaigns';
    return $self->SUPER::converter($type);
}

sub _validate_campaign_type {
    my ($self, $item, $is_required) = @_;

    my $count = 0;

    state $types = get_type_structures_names(convert_types_to_external($self->get_api_allowed_camp_types()));
    state $types_str = join(', ', @$types);

    foreach my $type (@$types) {
        $count++ if exists $item->object->{$type};
        if ($count > 1) {
            $item->add_error( error_PossibleOnlyOneField( iget('Кампания может содержать только один из объектов %s', $types_str)) );
            return 1;
        }

    }
    if(!$count && $is_required) {
        $item->add_error( error_RequiredAtLeastOneOfFields( iget('Кампания должна содержать один из объектов %s', $types_str) ) );
        return 1;
    }

    return; # ok
}

sub _get_supported_camp_kind {
    return 'api5_edit_campaigns_ext';
}

sub _convert_settings_to_external {
    my ($self, $model) = @_;

    my $result = convert_settings_to_external($model);

    if ($model->{type} eq 'text' || $model->{type} eq 'performance' || $model->{type} eq 'dynamic') {
        push $result, { Option => 'TURBO_APPS_ENABLED',
                        Value => $model->{opts}{has_turbo_app} ? 'YES' : 'NO' };
    }

    return $result;
}

1;
