package API::Service::Changes::CampaingChangeTypes;

=pod

    $Id$

=head1 NAME

    API::Service::Changes::CampaignChangeTypes — содержит типы изменений, которые произошли в кампании API v5

=head1 DESCRIPTION

   Служебный класс, для хранения и получения типов изменений, произошедших в кампании

=cut

use strict;
use warnings;
use utf8;

use Mouse;

has self => (is => 'rw', isa => 'Bool', lazy => 1, default => 0);
has children => (is => 'rw', isa => 'Bool', lazy => 1, default => 0);
has stat => (is => 'rw', isa => 'Bool', lazy => 1, default => 0);

=head2 enable_self

    Устанавливаем флаг наличия изменений в параметрах кампании

=cut

sub enable_self { shift->self(1) }

=head2 enable_children

    Устанавливаем флаг наличия изменений в дочерних объектах кампании

=cut

sub enable_children { shift->children(1) }

=head2 enable_stat

    Устанавливаем флаг наличия изменений в статистике кампании

=cut

sub enable_stat { shift->stat(1) }

=head2 list

    Получаем список типов изменений в кампании

=cut

sub list {
    my ($self) = @_;
    return [
        ($self->self ? 'SELF' : ()),
        ($self->children ? 'CHILDREN' : ()),
        ($self->stat ? 'STAT' : ())
    ];
}

__PACKAGE__->meta->make_immutable();

1;
