package API::Service::Reports::ConvertMap;

use Direct::Modern;

use Mouse;

use API::Service::Reports::ConvertSubs qw/
    convert_format
    convert_yes_no
/;

extends 'API::Converter::ConvertMap';

=head2 build_to_internal_map

    Метод возвращает хэш с описанием, как конвертировать внешние данные, полученные от клиента во внутренние для заданного сервисного метода

=cut

sub build_to_internal_map {
    my ($self) = @_;
    my $map = {
        create => {
            SelectionCriteria => \&_convert_selection_criteria,
            Goals => \&_convert_goals,
            AttributionModels => \&_convert_attribution_models,
            FieldNames => 'field_names',
            DateRangeType => 'date_range_type',
            ReportName => 'report_name',
            ReportType => 'report_type',
            Currency => 'currency',
            Format => [ format => \&convert_format ],
            IncludeVAT => [ with_nds => \&convert_yes_no ],
            OrderBy => [ order_by => {
                Field => 'field',
                SortOrder => 'dir',
            }],
            Page => [ page => \&_convert_page ],
        },
    };
    return $map->{$self->method};
}

sub _convert_selection_criteria {
    my ($data) = @_;

    my %result;
    $result{start_date} = $data->{DateFrom} if exists $data->{DateFrom};
    $result{end_date} = $data->{DateTo} if exists $data->{DateTo};

    if (exists $data->{Filter}) {
        $result{filter} = [ map { { field => $_->{Field}, operator => $_->{Operator}, values => $_->{Values} } } @{$data->{Filter}} ];
    }

    return \%result;
}

sub _convert_page {
    my ($page) = @_;
    return {limit => $page->{Limit}, exists $page->{Offset} ? (offset => $page->{Offset}) : ()};
}

sub _convert_goals {
    my ($goals) = @_;
    return { goal_ids => { field => 'Goals', operator => "IN", values => $goals }};
}

sub _convert_attribution_models {
    my ($attribution_types) = @_;
    return { attribution_models => { field => 'AttributionModels', operator => "IN", values => $attribution_types }};
}

__PACKAGE__->meta->make_immutable();

1;
