package API::Service::Reports::RateLimit;

=pod

    $Id$

=head1 NAME

    API::Service::Reports::RateLimit — модуль для регулирования частоты обращений клиентов к сервису Reports

=head1 SYNOPSIS
    
    my $rl = API::Service::Reports::RateLimit->new();
    my $limit_error =$rl->check( $self->subclient_client_id );
    return $limit_error if $limit_error;

=head1 DESCRIPTION

   Функции, упрощающие написание модульных тестов для сервисов API.

=cut

use Direct::Modern;

use Yandex::I18n qw/iget/;

use Settings;
use Direct::Errors::Messages;
use DirectRedis;

use Mouse;

our $TIME_INTERVAL = 10;
our $REQUESTS_NUMBER = 20;

has redis => ( is => 'ro', isa => 'Object', default => sub { DirectRedis::get_redis(); } );

=head2 check($request)

    Проверяет возможность запросить отчет в текущий интервал времени
    Если статистику по кампаниям клинта запрашивают чаще чем n раз в m секунд возвращает ошибку 

=cut

sub check {
    my ($self, $client_id) = @_;
    my $dr = $self->redis();
    my $redis_key = _get_key($client_id);
    my $set_result = $dr->set($redis_key, 1, 'EX', $TIME_INTERVAL, 'NX');
    my $requests_number;
    if ( !$set_result || $set_result ne 'OK' ) {
        $requests_number = $dr->incr($redis_key);
        
        if ( $requests_number > $REQUESTS_NUMBER ) {
            return error_RateLimitExceeded(
                iget("Данный метод можно запрашивать не чаще чем %d раз в %d секунд", $REQUESTS_NUMBER, $TIME_INTERVAL)
            )
        }
    }

    return;
}

sub _get_key {
    my ($client_id) = @_;
    my $prefix = $Settings::REDIS_KEY_PREFIX . 'reports-requests-number';
    my $current_time = time();
    my $redis_key = $prefix . '-' . $client_id . '-' . ( $current_time - ($current_time % $TIME_INTERVAL) );
    return $redis_key;
}

__PACKAGE__->meta->make_immutable();

1;
