package API::Service::Request::Delete;

use strict;
use warnings;
use utf8;

=pod

    $Id$

=head1 NAME

    API::Service::Request::Delete

=head1 SYNOPSIS

    my $delete_request = API::Service::Request::Delete->new($request);
    if(my $e = $delete_request->validate_selection_criteria(
        at_least_one => [qw/Ids/],
        limits => { Ids => 1000 }
    )) {
        return $e;
    }

    my $ids = $delete_request->selection_ids('Ids');
    # Тождествено
    # my $ids = $delete_request->ids();

=head1 DESCRIPTION

    Класс для получения данных и валидации Delete запроса. По сути обертка на API::Service::Request::Get

=head1 METHODS

=head2 ids_fields

    Название поля в SelectionCriteria, содержащее id удаляемых объектов

=head2 ids

    Возвращает массив чисел из SelectionCriteria/<ids_field>
    ids_field можно переопределить через одноименный ассессор, значение по умолчанию Ids

=cut

use Mouse;
extends 'API::Service::Request::Get';

has ids => (is => 'ro', isa => 'ArrayRef[Int]', lazy => 1, auto_deref => 1, default => sub {
    [ shift->selection_ids('Ids') ]
});

has ids_field => (is => 'rw', isa => 'Str', default => 'Ids');

__PACKAGE__->meta->make_immutable;

1;

__END__
