package API::Service::Request::Get::GetWithType;

use strict;
use warnings;
use utf8;

=pod

    $Id$

=head1 NAME

    API::Service::Request::Get::GetWithType

=head1 SYNOPSIS


=head1 DESCRIPTION

    

=head1 METHODS

=head2 new($request)

    $request запрос поступающий в операцию сервиса

=cut

use Mouse;

extends 'API::Service::Request::Get';

has request => (is => 'ro', isa => 'HashRef');

has fields_for_all_types => (
    is => 'ro', isa => 'HashRef',
    lazy => 1,
    default => sub {
        my $self = shift;
        my %fields;
        for my $type (@{$self->types}){
            for my $field ($self->to_strings($self->request->{$type.'FieldNames'})) {
                $fields{$field} = 1;
            }
        }
        for my $field ($self->to_strings($self->request->{'FieldNames'})) {
            $fields{$field} = 1;
        }
        return \%fields;
    },
);

sub BUILDARGS {
    my $class = shift;
    my $request = shift;
    return { request => $request };
}

=head2 field_names_by_type
    Получает поля зависящие от переданного типа, которые запросили в FieldNames
    
=cut

sub field_names_by_type {
    my ($self, $type) = @_;
    return $self->to_strings($self->request->{$type.'FieldNames'});
}

=head2 needed_field_names_by_type
    Получает необходимые для ответа поля из общего списка FieldNames и зависящие от переданного типа
    
=cut

sub needed_field_names_by_type {
    my ($self, $type) = @_;
    return ($self->field_names, $self->field_names_by_type($type));
}

=head2 is_in_field_names_for_all_types

    Проверяет нужно ли это поле в ответе независимо от типа

=cut

sub is_in_field_names_for_all_types {
    my ($self, $field_name) = @_;
    return exists $self->fields_for_all_types->{$field_name} ? 1 : 0;
}

__PACKAGE__->meta->make_immutable();

1;

__END__
