package API::Service::ResultSet::Add;

use strict;
use warnings;
use utf8;

use API::Service::ResultSet::Indexed;

use API::Service::ResultSet::AddItem;

sub item_class { 'API::Service::ResultSet::AddItem' }

=head2 prepare_for_xml_with_ids(@new_ids)

    получает id-шники созданных в add-методе объектах и возвращает ссылку на
    массив пригодную для использования в качестве ответа add метода

=cut

sub prepare_for_xml_with_ids {
    my $self = shift;
    my @new_ids = @_;# real ids, not index

    my @list = $self->list;
    return [
        map {
            my $item = $self->get($_);
            $self->id_item_to_xml($new_ids[$_], $item);
        } 0..$#list
    ];
}

1;
