#!/usr/bin/perl

use Direct::Modern;

use Test::More;
use Test::Exception;

use Try::Tiny;
use API::Authorization;

token_ok('afghjklmnopxyzqvwaaaaaaaaaaaaaaaaa');
token_ok('afGHJKLMNOPXYZQVWAAAAAaaaaaaaaaaaa');
token_ok('012356789aaaaaaaaaaaaaaaaaaaaaaaaa');
token_ok('012356789aaaaaaaaaaaaaaaaaaaaaaa==');
token_ok('++012356789aaaaaaaaaaaaaaaaaaaaaaa++');
token_ok('-');
token_ok('.');
token_ok('_');
token_ok('~');
token_ok('/');
token_ok( token_with_length(1026), "token a*1025" );
dies_ok(sub { new_auth_with_token( ' ' ) }, "empty space token is invalid");
dies_ok(sub { new_auth_with_token( '' ) }, "empty token is invalid");


token_not_ok($_) foreach (qw/! @ $ % ^ & * ( ) [ ] ; : ' " ? \\ `/, '#', ',');
token_not_ok('aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa!');
token_not_ok('==aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa');
done_testing();

sub token_not_ok {
    my $token = shift;
    dies_ok(sub {new_auth_with_token($token)}, "token $token is invalid");
}

sub token_ok {
    my $token = shift;
    my $msg = shift || "token $token valid";
    my $auth;
    try {
        $auth = new_auth_with_token($token);
    };

    ok($auth && $auth->token eq $token, $msg);
}

sub new_auth_with_token {
    my $token = shift;
    return API::Authorization->new(
        token => $token,
        application_id => $token,
        ip => '127.0.0.1',
        remote_address => '127.0.0.1',
        request_id => 1235,
    );
}

sub token_with_length {
    return 'a' x $_[0];
}
