#!/usr/bin/perl

# $Id$

=head1 NAME

    t/runtests.pl

=head1 SYNOPSIS

    ./t/runtests.pl # все тесты
    ./t/runtests.pl v5/keywords.t # запуск ./t/keywords.t

=head1 DESCRIPTION

    Запуск всех юнит тестов или только одного файла, ВРЕМЕННОЕ РЕШЕНИЕ

=cut

use warnings;
use strict;

use File::Find;
use TAP::Harness;


use FindBin qw/$Bin/;
use my_inc "../..", for => "api/t";
use Settings;

my @test_files;

if(@ARGV) {
    @test_files = @ARGV;
} else {
    find(
        {
            wanted => sub {
                push @test_files, $File::Find::name if -f $_
            },
            preprocess => sub {
                return grep { -d || /\.(?:t|py)$/ } @_;
            },
        }, $Bin
    );
}

my $cwd = POSIX::getcwd();
map {s!^$cwd/!!; $_} @test_files;

my $harness = TAP::Harness->new( {
    verbosity => 1,

    lib => [
        "$Bin/../../protected",
        "$Bin/../lib",
        "$Bin/../services/v5",
        "$Bin/../generated_sources/v5",
        "$Bin/../../perl/rbac-elementary",
        "$Bin/../../perl/settings",
    ],
});

$ENV{SETTINGS_LOCAL_SUFFIX} = 'ForUnitTests';

# чтобы при прерывании lock-файлы не висели вечно
$ENV{UNITTESTS_TMP_DIRECTORY} = '/tmp/temp-ttl/ttl_2d' if (-d '/tmp/temp-ttl/ttl_2d');

# подозрительного вида хак для совместимости TAP::Harness и utf-ного вывода тестов
binmode(STDOUT, ':raw');
binmode(STDERR, ':raw');

my $agg = $harness->runtests(@test_files);
exit $agg->has_errors ? 1 : 0;

