#!/usr/bin/perl
use Direct::Modern;

use Test::Deep;
use Test::More tests => 1;

use Template;
use XML::Compile::Schema;

use my_inc '../../../..', for => 'api/t';
use Direct::Validation::Image;
use Settings;

my @XSD_NAMES = qw( adimages general );

my %XSD_NAME_TO_FILENAME = (
    'adimages' => "$Settings::ROOT/api/wsdl/v5/AdImages.wsdl",
    'general' => "$Settings::ROOT/api/wsdl/v5/general.xsd",
);

my %XSD_NAME_TO_NAMESPACE = (
    'adimages' => 'http://api.direct.yandex.com/v5/adimages',
    'general' => 'http://api.direct.yandex.com/v5/general',
);

my $template = Template->new( ABSOLUTE => 1, LOAD_PERL => 1 );

my $schema = XML::Compile::Schema->new;
for my $xsd_name (@XSD_NAMES) {
    my $xsd_content;
    $template->process($XSD_NAME_TO_FILENAME{$xsd_name}, {
        api_version => 5,
        is_beta => 0,
        lang => 'ru',
        API_SERVER_PATH => "https://api.direct.yandex.ru",
    }, \$xsd_content);

    $schema->importDefinitions(\$xsd_content);
}

sub get_enum_values {
    my ($xsd_name, $enum_name) = @_;
    my $ns = $XSD_NAME_TO_NAMESPACE{$xsd_name};
    my $enum_element = $schema->namespaces->find('simpleType' => "{$ns}$enum_name")->{node};

    my @values;
    for my $value_element ( $enum_element->getElementsByTagName("xsd:enumeration") ) {
        push @values, $value_element->getAttribute('value');
    }

    return sort @values;
}

my @wsdl_subtypes = get_enum_values('adimages', 'AdImageSubtypeEnum');
my @expected_subtypes = ( ( map {
    "IMG_" . $_->[0] . "_" . $_->[1],
    "IMG_" . $_->[0] * 2 . "_" . $_->[1] * 2,
    "IMG_" . $_->[0] * 3 . "_" . $_->[1] * 3
} @Direct::Validation::Image::VALID_SIZES_ORIGIN ), 'NONE');
cmp_deeply( \@wsdl_subtypes, bag(@expected_subtypes), 'wsdl subtypes match acceptable image types' );
