#!/usr/bin/perl

use strict;
use warnings;
use utf8;

=pod
=encoding utf8

    $Id:$

=head1 NAME

    units_reset_or_withdraw.t

=head1 DESCRIPTION

    Тест проверяет, что мы не списываем баллы с внутренних ролей, но списываем с клиента

=cut

package Test::Units;

sub new {
    my ($class, $units) = @_;
    return bless { limit => $units, balance => $units }, $class;
}

sub limit { shift->{limit} }

sub balance { shift->{balance} }

sub withdraw {
    my ($self, $amount) = @_;
    $self->{balance} = $self->{balance} - $amount;
    return 1;
}

1;

package main;

use Test::More;

use API::Service::Base;

my $service_name = 'Campaigns';
my $role = 'client';
my $operation = 'add';
my $limit = 1000;
my $units = Test::Units->new($limit);
{
    no warnings 'redefine';
    *API::Service::Base::operator_role = sub { $role };
    *API::Service::Base::service_name = sub { $service_name };
    *API::Service::Base::current_operation = sub { $operation };
    *API::Service::Base::units = sub { $units };
}

my $service = API::Service::Base->new();

my $withdraw_methods = {
    units_withdraw_for_operation => [],
    units_withdraw_for_request_error => [],
    units_withdraw_for_objects => [ campaign => 2],
    units_withdraw_for_objects_with_errors => [ 3 ],
};

ok($service->units_balance == $limit, "$limit units");

for my $withdraw_method (sort keys %$withdraw_methods) {
    my $balance = $service->units_balance;
    withdraw($service, $withdraw_method, @{ $withdraw_methods->{$withdraw_method} } );
    my $spent = $balance - $service->units_balance;
    ok($spent > 0, "spent $spent units for $withdraw_method by role $role");
}

for my $r (qw/super superreader placer media support manager/) {
    $role = $r;
    my $balance = $service->units_balance;
    for my $withdraw_method (sort keys %$withdraw_methods) {
        withdraw($service, $withdraw_method, @{ $withdraw_methods->{$withdraw_method} } );
        ok($balance == $service->units_balance, "$withdraw_method costs nothing for $role");
    }
}

sub withdraw {
    my ($service_obj, $method, @params) = @_;
    $service_obj->$method(@params);
}

done_testing;

1;
