#!/usr/bin/perl
use Direct::Modern;

use Test::More tests => 4;
use Try::Tiny;

use Yandex::DBUnitTest ':all';
use Yandex::DBTools;

use my_inc '../../../..', for => 'api/t';
use Settings;
use API::Service::Campaigns::ConvertSubs;

sub test {
    my ( $test_name, $timezone, $table_data, $expected_timezone_id, $expected_warning_re ) = @_;

    subtest $test_name => sub {
        try {
            my $country_id = 1;
            for my $row (@$table_data) {
                do_insert_into_table( PPCDICT, 'geo_timezones', { %$row, country_id => $country_id++ } );
            }

            if ($expected_warning_re) {
                my $warning;
                local $SIG{__WARN__} = sub { ($warning) = @_ };
                my $tz_id = API::Service::Campaigns::ConvertSubs::convert_time_zone($timezone);
                is( $tz_id, $expected_timezone_id, 'timezone_id matches' );
                like( $warning, $expected_warning_re, 'warnings match' );
            } else {
                my $tz_id = API::Service::Campaigns::ConvertSubs::convert_time_zone($timezone);
                is( $tz_id, $expected_timezone_id, 'timezone_id matches' );
            }
        } catch {
            die $_;
        } finally {
            do_sql( PPCDICT, 'TRUNCATE TABLE geo_timezones' );
        };
    };
}

copy_table('ppcdict', 'geo_timezones');

test(
    'Has valid Moscow for Europe/Moscow, nothing else for Europe/Moscow',
    'Europe/Moscow',
    [
        { timezone_id => 5, timezone => 'Europe/Moscow', name => 'Москва', group_nick => 'russia' },
    ],
    5,
    undef,
);

test(
    'Has valid Moscow for Europe/Moscow, one more entry for Europe/Moscow',
    'Europe/Moscow',
    [
        { timezone_id => 5, timezone => 'Europe/Moscow', name => 'Москва', group_nick => 'russia' },
        { timezone_id => 3, timezone => 'Europe/Moscow', name => 'Южная Осетия', group_nick => 'cis' },
    ],
    5,
    undef,
);

test(
    'No valid Moscow for Europe/Moscow, one more entry for Europe/Moscow',
    'Europe/Moscow',
    [
        { timezone_id => 3, timezone => 'Europe/Moscow', name => 'Южная Осетия', group_nick => 'cis' },
    ],
    3,
    qr/Couldn't find timezone/,
);

test(
    'No valid Moscow for Europe/Moscow, no more entries for Europe/Moscow',
    'Europe/Moscow',
    [],
    undef,
    qr/Couldn't find timezone/,
);
