#!/usr/bin/perl
use Direct::Modern;
use my_inc '../../../..', for => 'unit_tests';

use Test::More tests => 8;
use Test::Deep;

use API::Test::Reports::Fields qw/@REPORT_TYPES/;

use Yandex::DateTime 'now';

BEGIN {
    use_ok('API::Reports::DataRules', qw/
            get_all_field_names
            get_all_operators
            get_all_order_directions
            get_all_report_types
            get_all_date_ranges
    /);
}

subtest 'get_all_field_names' => sub {
    local %API::Reports::DataRules::FIELD_DESC = (
        Yyy => { },
        Xxx => { },
    );
    cmp_deeply(get_all_field_names(), ['Xxx', 'Yyy'], 'it should return sorted array of field names');
};


subtest 'get_all_operators' => sub {
    local %API::Reports::DataRules::OPERATOR_DESC_MAP = (
        OP2 => { },
        EQUALS => { },
    );
    cmp_deeply(get_all_operators(), ['EQUALS', 'OP2'], 'it should return sorted array of operators');
};


subtest 'get_all_order_directions' => sub {
    local %API::Reports::DataRules::ORDER_DIRECTION_MAP = (
        DIR2 => { },
        DIR1 => { },
    );
    cmp_deeply(get_all_order_directions(), ['DIR1', 'DIR2'], 'it should return sorted array of order directions');
};


subtest 'get_all_report_types' => sub {
    cmp_deeply(get_all_report_types(), \@REPORT_TYPES, 'it should return sorted array of report types');
};

subtest 'get_all_date_ranges' => sub {
    local %API::Reports::DataRules::DATE_RANGE_TYPE_MAP = (
        DR2 => undef,
        DR1 => undef,
    );
    cmp_deeply(get_all_date_ranges(), ['DR1', 'DR2'], 'it should return sorted array of date ranges');
};

subtest '_bs_stat_availability_date_getter' => sub {
    cmp_deeply(API::Reports::DataRules::_bs_stat_availability_date_getter(), now()->truncate(to => 'month')->subtract(years => 3)->ymd('-'), 'it should return correct start date (3 years before)');
};

subtest 'get_countable_fields' => sub {
    plan tests => 2;
    cmp_deeply(API::Reports::DataRules::get_countable_fields(), [], 'no fields asked, no fields produced');
    cmp_deeply(API::Reports::DataRules::get_countable_fields(qw/AdGroupId ImpressionShare Ctr AvgPageviews/), [qw/winrate clicks shows aseslen asesnum asesnumlim/],
        'it should return fields for the last three params that actually need them');
};
