
use Direct::Modern;

use Path::Tiny;
use Test::More;

use my_inc '../../../..', for => 'api/t';
use Settings;

my %SUB_COVERED_BY = (
    'Reports::convert_client_request_to_internal_representation' => 'convert_client_request_to_internal_representation.t',
    'Reports::create' => 'create.t',
    'Reports::_convert_request_data_to_report_params' => 'reports.t',
    'Reports::_populate_request_data' => 'reports.t',
    'Reports::_validate_create' => 'reports.t',
    'Reports::_filter_inaccessible_cids' => 'reports.t',
    'Reports::_restrict_campaign_ids_by_ad_ids' => 'reports.t',
    'Reports::_restrict_campaign_ids_by_adgroup_ids' => 'reports.t',
    'Reports::_get_accessible_client_ids' => 'reports.t',
    'Reports::_get_accessible_client_cids_with_stats' => 'get_all_client_cids_with_stats.t',
    
    'Reports::Builder::_make_report_title' => 'builder.t',

    'Reports::FormatTsv::tsv_line' => 'format_tsv.t',

    'Reports::DataRules::get_all_field_names' => 'common.t',
    'Reports::DataRules::get_all_operators' => 'common.t',
    'Reports::DataRules::get_all_order_directions' => 'common.t',
    'Reports::DataRules::get_all_report_types' => 'common.t',
    'Reports::DataRules::get_all_date_ranges' => 'common.t',
    'Reports::DataRules::_bs_stat_availability_date_getter' => 'common.t',
    'Reports::DataRules::get_countable_fields' => 'common.t',


    'Reports::ConvertMap::build_to_internal_map' => 'convertmap.t',
    'Reports::ConvertMap::_convert_selection_criteria' => 'convertmap.t',
    'Reports::ConvertMap::_convert_order_by' => 'convertmap.t',
    'Reports::ConvertMap::_convert_page' => 'convertmap.t',
    'Reports::ConvertMap::_convert_goals' => 'convertmap.t',
    'Reports::ConvertMap::_convert_attribution_models' => 'convertmap.t',

    'Reports::ConvertSubs::convert_format' => 'convert_subs.t',
    'Reports::ConvertSubs::convert_field_names_and_report_type_to_group_by' => 'convert_subs.t',
    'Reports::ConvertSubs::convert_field_names_to_date_aggregation' => 'convert_subs.t',
    'Reports::ConvertSubs::convert_field_names_to_report_fields' => 'convert_subs.t',
    'Reports::ConvertSubs::convert_field_names_to_countable_fields' => 'convert_subs.t',
    'Reports::ConvertSubs::convert_filter_items' => 'convert_subs.t',
    'Reports::ConvertSubs::convert_yes_no' => 'convert_subs.t',
    'Reports::ConvertSubs::convert_none' => 'convert_subs.t',
    'Reports::ConvertSubs::convert_order_by_items' => 'convert_subs.t',
    'Reports::ConvertSubs::convert_page_filter' => 'convert_subs.t',
    'Reports::ConvertSubs::convert_page_name_filters' => 'convert_subs.t',

    'Reports::ConvertSubs::get_dates_by_range' => 'get_dates_by_range.t',

    'Reports::ProcessingModeChooser::_require_offline_mode' => 'processing_mode_chooser.t',
    'Reports::ProcessingModeChooser::choose_processing_mode' => 'processing_mode_chooser.t',
    'Reports::ProcessingModeChooser::require_offline_mode_adjusted' => 'processing_mode_chooser.t',

    'Reports::ReportRowProcessor::process_report_row' => 'process_report_row.t',

    'Reports::Validation::validate_create_report_request' => 'validation.t',
    'Reports::Validation::_validate_create_field_names' => 'validation.t',
    'Reports::Validation::_validate_create_date_range' => 'validation.t',
    'Reports::Validation::_validate_create_filter_items' => 'validation.t',
    'Reports::Validation::_validate_filter_item_value' => 'validation.t',
    'Reports::Validation::validate_value_against_type' => 'validation.t',
    'Reports::Validation::_validate_create_page' => 'validation.t',
    'Reports::Validation::_validate_create_order_by' => 'validation.t',
    'Reports::Validation::_validate_create_report_name' => 'validation.t',
    'Reports::RateLimit::check' => 'rate_limit.t',
);

my @SUBS_NOT_TESTED = (
    'Reports::access_allowed_to_application',
    'Reports::response_ids',
    'Reports::count_error_warning_objects_in_reponse',
    'Reports::_get_accessible_cids',
    'Reports::_get_inaccessible_cids',
    'Reports::_get_subcampaigns',
    'Reports::_get_subclient_currency',
    'Reports::_tsv_line',
    'Reports::_convert_types',
    'Reports::_get_names_in_provider_response',
    'Reports::_get_displayed_field_names',
    'Reports::_has_fields_dependent_on_goal',
    'Reports::include_request_headers_in_logs',
    'Reports::add_request_headers_to_log',
    'Reports::_replace_audience_target_id',
    'Reports::_delete_report_from_db',

    'Reports::DataRules::_bs_stat_availability_date_getter',
    'Reports::DataRules::_not_available_error_msg_getter',

    'Reports::Builder::build_report',

    'Reports::ReportRowProcessor::_has_special_value',
    'Reports::ReportRowProcessor::_get_special_value',
    'Reports::ReportRowProcessor::_has_result_map',
    'Reports::ReportRowProcessor::_get_result_value',
    'Reports::ReportRowProcessor::_is_money_field',
    'Reports::ReportRowProcessor::_get_type',
    'Reports::ReportRowProcessor::_has_type',

    'Reports::Result::data_iterator',

    # но при этом есть resulting_data_iterator.t, который приблизительно "проверяет всё вместе"
    'Reports::ResultingDataIterator::new',
    'Reports::ResultingDataIterator::has_next_row',
    'Reports::ResultingDataIterator::next_row',
    'Reports::ResultingDataIterator::_try_refill_buffer',
    'Reports::RateLimit::_get_key',

    'Reports::InternalRequestRepresentation::to_plain_struct',
    'Reports::InternalRequestRepresentation::from_plain_struct',

    'Reports::OfflineReportTask::DBQUEUE_JOB_TYPE',
    'Reports::OfflineReportTask::STORAGE_FILE_TYPE',
    'Reports::OfflineReportTask::get_or_create',
    'Reports::OfflineReportTask::get_resulting_file',
    'Reports::OfflineReportTask::find_task',

    'Reports::Validation::_validate_dups_in_array_fields',
    'Reports::Validation::_is_valid_filter_age',
);

my %IS_SUB_NOT_TESTED = map { $_ => 1 } @SUBS_NOT_TESTED;

my $SERVICES_DIR_PATH = "$Settings::ROOT/api/services/v5/API/Service/";

my @files = (
    "$Settings::ROOT/api/services/v5/API/Service/Reports.pm",
    glob("$Settings::ROOT/api/services/v5/API/Service/Reports/*.pm"),
    glob("$Settings::ROOT/protected/API/Reports/*.pm"),
);

plan tests => scalar(@files);

# "Package::function_name" => "filename, line 123"
my %definition_info;

for my $file (@files) {
    my $path = path($file);

    my $relpath = $path->subsumes("$Settings::ROOT/api/services/v5/API/Service/") ?
        $path->relative("$Settings::ROOT/api/services/v5/API/Service/") :
        $path->relative("$Settings::ROOT/protected/API/");

    subtest $relpath => sub {
        my @file_lines = $path->lines_utf8;

        my ( $package, @subs );
        my $line_num = 0;
        for my $line (@file_lines) {
            $line_num++;

            if ( $line =~ /^\s*sub\s+(\w+)/ ) {
                my $sub_name = $1;
                my $package_short = ( $package =~ s/^API::(?:Service::)?//r );
                push @subs, $sub_name;
                $definition_info{"${package_short}::${sub_name}"} = "$relpath, line $line_num";
            }

            if ( $line =~ /^\s*package\s*([\w:]+)/ ) {
                $package = $1;
            }
        }

        die "Package not defined for $relpath" unless $package;

        unless (@subs) {
            plan skip_all => "no subs in $relpath";
            return;
        }

        my $package_short = ( $package =~ s/^API::(?:Service::)?//r );

        plan tests => scalar(@subs);

        for my $sub (@subs) {
            my $qualified_name = "${package_short}::${sub}";
            if ( my $testname = $SUB_COVERED_BY{$qualified_name} ) {
                pass("$qualified_name ($definition_info{$qualified_name}): covered by $testname");
            } elsif ( $IS_SUB_NOT_TESTED{$qualified_name} ) {
                pass("$qualified_name ($definition_info{$qualified_name}): deliberately not covered");
            } else {
                fail("$qualified_name ($definition_info{$qualified_name}): needs coverage");
            }
        }
    };
}
