#!/usr/bin/perl
use Direct::Modern;
use my_inc '../../../..', for => 'unit_tests';

use Test::More tests => 66;

use Test::Deep;

use API::Reports::DataRules qw/%FIELD_DESC %REPORT_TYPE_CONF/;

my %EXTENDED_STRING_FIELDS = (
    Keyword => 1,
    MatchedKeyword => 1,
    Query => 1
);

my %RESTRICTED_FIELDS = (
    CampaignId => [qw/EQUALS IN/],
    AdNetworkType => [qw/EQUALS IN/],
    CampaignType => [qw/EQUALS IN/],
    AttributionModels => [qw/IN/],
    Goals => [qw/IN/],
    ClientLogin => [qw/EQUALS IN/],
);


sub test_operations {
    my ($field, $params) = @_;
    my $filter = $params->{filter};
    my $type = $params->{type};
    ok(defined $filter->{ops}, 'need key "ops" in the structure "filter"');
    my $ops = $filter->{ops};
    my $is_single_value = exists $filter->{single_value} ? 1: 0;
            
    my $test_name = "field \"$field\" has correct operations";
    if ( exists $RESTRICTED_FIELDS{$field} ) {
        cmp_bag( $ops, $RESTRICTED_FIELDS{$field}, $test_name );
    } elsif ( $type eq 'Id' ) {
        if ( $is_single_value ) {
            cmp_bag( $ops, [qw/EQUALS/], $test_name );
        } else {
            cmp_bag( $ops, [qw/EQUALS IN NOT_EQUALS NOT_IN/], $test_name );
        }
    } elsif ( $type eq 'Money' ||  $type eq 'Float' || $type eq 'SignedMoney' ) {
        cmp_bag( $ops, [qw/GREATER_THAN LESS_THAN/], $test_name );
    } elsif ( $type eq 'String' && not exists $EXTENDED_STRING_FIELDS{$field} ) {
        #if ( $is_single_value ) {
        #    cmp_bag( $ops, [qw/EQUALS/], $test_name );
        #} else {
            cmp_bag( $ops, [qw/EQUALS IN NOT_EQUALS NOT_IN/], $test_name );
        #}
    } elsif ( $type eq 'String' && exists $EXTENDED_STRING_FIELDS{$field} ) {
        cmp_bag( $ops, [qw/EQUALS IN NOT_EQUALS NOT_IN STARTS_WITH_IGNORE_CASE STARTS_WITH_ANY_IGNORE_CASE DOES_NOT_START_WITH_IGNORE_CASE DOES_NOT_START_WITH_ALL_IGNORE_CASE/], $test_name );
    } elsif ( $type eq 'Region' ) {
        cmp_bag( $ops, [qw/EQUALS IN NOT_EQUALS NOT_IN/], $test_name );
    } elsif ( $type eq 'Integer' ) {
        cmp_bag( $ops, [qw/EQUALS IN GREATER_THAN LESS_THAN/], $test_name );
    } else {
        ok(0, "unknown field \"$field\" type \"$type\"");
    }
    return;
}

my @all_params;
for my $field (keys %FIELD_DESC) {
    if ( $FIELD_DESC{$field}->{filter} ) {
        push @all_params, [ 'FIELD_DESC', $field, $FIELD_DESC{$field} ];
    }
}

for my $type (keys %REPORT_TYPE_CONF) {
    my $conf = $REPORT_TYPE_CONF{$type};
    if ( exists $conf->{field_overwrite} ) {
        my @fields = keys %{ $conf->{field_overwrite} };
        for my $field (@fields) {
            if ( exists $conf->{field_overwrite}{$field}{filter} ) {
                push @all_params, [ 'REPORT_TYPE_CONF', $field, $conf->{field_overwrite}{$field} ];
            }
        }

    }
}

for my $params (@all_params) {
    my ($hash_name, $field, $field_params) = @$params;
    subtest "check structure \"filter\" for field $field in $hash_name" 
            => sub { \&test_operations($field, $field_params) };
}
