#!/usr/bin/perl
use Direct::Modern;

use Test::More tests => 1;

use my_inc '../../../..', for => 'protected';
use API::Reports::FormatTsv 'tsv_line';

subtest 'tsv_line' => sub{
    is(tsv_line([]), "\n", 'for empty array it should return empty string terminated with newline');
    is(tsv_line(['фф']), "фф\n", 'for one value array it should return that value terminated with newline');
    is(tsv_line(['фф', 'яя']), "фф\tяя\n", 'for multiple values it should return string with values separated by tab symbol and terminated with newline');
    is(tsv_line(["\t\t\ttest\r\n string\t1\n\n","test\r\nstring 2\t\t"]), " test  string 1 \ttest string 2 \n", 'string with removed \r\n\t in field content');
};

