#!/usr/bin/perl
use strict;
use warnings;

use my_inc '../../../..', for => 'unit_tests';
use utf8;

use Test::More;
use Test::Deep;

use API::Test::MockHelper qw/mock_subs restore_mocked_subs/;

use Settings;
use Yandex::Test::UTF8Builder;
use Yandex::DBTools;
use Yandex::DBUnitTest qw/:all/;
$Yandex::DBShards::STRICT_SHARD_DBNAMES = 0;


copy_table(PPC(shard => 'all'), 'campaigns');
copy_table(PPC(shard => 'all'), 'subcampaigns');
copy_table(PPCDICT, 'shard_inc_cid');
copy_table(PPCDICT, 'shard_client_id');

my $ClientID = 12345;
my $ClientID2 = 12347;
foreach my $client_id ($ClientID, $ClientID2) {
    do_insert_into_table(UT, 'shard_client_id', {
                ClientID => $client_id,
                shard => 1 });
}
foreach my $cid (111, 222, 333, 444, 555, 666, 888) {
	do_insert_into_table(UT, 'shard_inc_cid', {
				cid => $cid,
                ClientID => $ClientID });
}

do_insert_into_table(SHUT_1, 'campaigns', {ClientID=>$ClientID, cid => 111, statusEmpty => 'No', OrderID => 1111, type=>'text'});
do_insert_into_table(SHUT_1, 'campaigns', {ClientID=>$ClientID2, cid => 112, statusEmpty => 'No', OrderID => 1112, type=>'text'});
do_insert_into_table(SHUT_1, 'campaigns', {ClientID=>$ClientID, cid => 222, statusEmpty => 'No', OrderID => 2222, type=>'performance'});
do_insert_into_table(SHUT_1, 'campaigns', {ClientID=>$ClientID, cid => 333, statusEmpty => 'No', OrderID => 2222, type=>'dynamic'});
do_insert_into_table(SHUT_1, 'campaigns', {ClientID=>$ClientID, cid => 444, statusEmpty => 'No', OrderID => 2222, type=>'mobile_content'});
do_insert_into_table(SHUT_1, 'campaigns', {ClientID=>$ClientID, cid => 555, statusEmpty => 'Yes', OrderID => 2222, type=>'performance'});
do_insert_into_table(SHUT_1, 'campaigns', {ClientID=>$ClientID, cid => 666, statusEmpty => 'No', OrderID => 0, type=>'performance'});
do_insert_into_table(SHUT_1, 'campaigns', {ClientID=>$ClientID+1, cid => 777, statusEmpty => 'No', OrderID => 1111, type=>'text'});
do_insert_into_table(SHUT_1, 'campaigns', {ClientID=>$ClientID, cid => 888, statusEmpty => 'No', OrderID => 1111, type=>'text'});
do_insert_into_table(SHUT_1, 'campaigns', {ClientID=>$ClientID, cid => 999, statusEmpty => 'No', OrderID => 2222, type=>'performance'});
do_insert_into_table(SHUT_1, 'subcampaigns', {cid => 999, master_cid => 111});

plan tests => 1;

use API::Service::Reports;

my $S = API::Service::Reports->new('Reports');

subtest '_get_accessible_client_cids_with_stats' => sub{
    mock_subs(
       'API::Service::Reports::_get_accessible_cids' => [{
           args => [ignore(), [111, 888]],
           result => {111 => 1, 888 => 1},
       }, {
           args => [ignore(), [111, 112, 888]],
           result => {111 => 1, 112 => 1, 888 => 1},
       }, {
           args => [ignore(), [111]],
           result => {111 => 1},
       }, {
           args => [ignore(), [111, 222, 888]],
           result => {111 => 1, 222 => 1, 888 => 1},
       }, {
           args => [ignore(), [111]],
           result => {111 => 1},
       }],
    );
    cmp_bag($S->_get_accessible_client_cids_with_stats([], ['text'], [$ClientID]), [111, 888]);
    cmp_bag($S->_get_accessible_client_cids_with_stats([], ['text'], [$ClientID, $ClientID2]), [111, 112, 888]);
    cmp_bag($S->_get_accessible_client_cids_with_stats([111], ['text'], [$ClientID]), [111]);
    cmp_bag($S->_get_accessible_client_cids_with_stats([444], ['text'], [$ClientID]), []);
    cmp_bag($S->_get_accessible_client_cids_with_stats([], ['text', 'performance'], [$ClientID]), [111, 222, 888]);
    cmp_bag($S->_get_accessible_client_cids_with_stats([111, 999], ['text', 'performance'], [$ClientID]), [111]);
    restore_mocked_subs();
};

