#!/usr/bin/perl
use Direct::Modern;

use Template;
use Test::Deep;
use Test::More tests => 3;
use API::Test::Utils qw/get_error_with_ignored_description/;
use Direct::Errors::Messages;

use API::Service::Reports::RateLimit; 

my $max_requests_number = $API::Service::Reports::RateLimit::REQUESTS_NUMBER;
my $client_id = 1;

my $redis = MockRedis->new(value => 1);

subtest 'if need create new key' => sub {
    my $rl = API::Service::Reports::RateLimit->new(redis => $redis);
    is($rl->check($client_id), undef);
    is($rl->redis->{incr_is_called}, 0);
    like($rl->redis->{key}, qr/^reports-requests-number-$client_id-\d+/);
};

subtest 'if key exists' => sub {
    $redis->{value} = $max_requests_number - 1;
    my $rl = API::Service::Reports::RateLimit->new(redis => $redis);
    is($rl->check($client_id), undef);
    is($rl->redis->{incr_is_called}, 1);
};

subtest 'if max requests number exceeded' => sub {
    $redis->{value} = $max_requests_number;
    my $rl = API::Service::Reports::RateLimit->new(redis => $redis);
    cmp_deeply(
        $rl->check($client_id),
        get_error_with_ignored_description(error_RateLimitExceeded)
    );
};


my $number_of_set_calls = 0;

package MockRedis;

sub new {
    my $class = shift;
    my (%params) = @_;
    $params{incr_is_called} = 0;

    my $self = \%params;
    bless $self, $class;

    return $self;
}

sub incr {
    my ( $self, $key, $val ) = @_;
    $self->{incr_is_called} = 1;
    $self->{key} = $key;
    $self->{value} ++;
    return $self->{value};
}

sub set {
    my ( $self, $key ) = @_;
    $number_of_set_calls ++;
    my $set_result;
    if ($number_of_set_calls == 1) {
        $set_result = 'OK';
    } else {
        $set_result = undef;
    }
    $self->{key} = $key;
    return $set_result;
}

1;



