#!/usr/bin/perl
use Direct::Modern;
use my_inc '../../../..', for => 'unit_tests';

use Test::More tests => 481;

use API::Reports::DataRules qw/%REPORT_TYPE_CONF %FIELD_DESC/;
use API::Test::Reports::Fields qw/
    all_fields
    @REPORT_TYPES
/;

my %all_fields = map { $_ => 1 } all_fields();
$all_fields{AvgEffectiveCpmBid} = 1;
$all_fields{ClientLogin} = 1;
$all_fields{StrategyId} = 1;

foreach my $report_type (@REPORT_TYPES) {
    foreach my $key (qw/fields field_overwrite/) {
        next unless exists $REPORT_TYPE_CONF{$report_type}{$key};
        foreach my $field (keys %{$REPORT_TYPE_CONF{$report_type}{$key}}) {
            if (!exists $FIELD_DESC{$field}{not_in_field_names}) {
                ok(exists $all_fields{$field}, "check field $field in API::Reports::DataRules::REPORT_TYPE_CONF{$report_type}{$key}");
            }
        }
    }
}

