#!/usr/bin/perl
use Direct::Modern;

use Test::Deep;
use Test::More tests => 1;

use Yandex::ListUtils;

use my_inc '../../../..', for => 'protected';
use API::Reports::DataRules 'CUSTOM_REPORT_TYPE';
use API::Reports::ResultingDataIterator;

my $feed_data = [
    [
        { clicks => 1, shows => 2, ctr => 3 },
        { clicks => 4, shows => 5, ctr => 6 },
    ],
    [
        { clicks => 7, shows => 8, ctr => 9 },
        { clicks => 10, shows => 11, ctr => 12 },
    ],
];

my $stat_iterator = FakeStatIterator->new($feed_data);

my $iterator = API::Reports::ResultingDataIterator->new(
    stat_iterator => $stat_iterator,
    requested_report_fields => [ qw( clicks shows ctr ) ],
    report_type => CUSTOM_REPORT_TYPE,
);

my $extracted_data = [];
while ( $iterator->has_next_row ) {
    push @$extracted_data, $iterator->next_row;
}

my $expected_data = [ map { [ @$_{ qw( clicks shows ctr ) } ] } xflatten(@$feed_data) ];

cmp_deeply( $extracted_data, $expected_data, 'iterator smoke test: doesn\'t seem to miss any data' );

package FakeStatIterator;
use parent 'Stat::CustomizedArray::Iterator';

use Yandex::Clone;

sub new {
    my ( $class, $buffer ) = @_;
    return bless { buffer => yclone($buffer) }, $class;
}

sub next_chunk {
    my ($self) = @_;
    return shift @{ $self->{buffer} };
}
