#!/usr/bin/perl
use Direct::Modern;

=head1 NAME

xsd.t

=head1 DESCRIPTION

Проверяет, что в reports.xsd в разных enum значения соответствуют тем, которые записаны
в таблицах в перловом коде.

=cut

use Test::More tests => 4;
use Test::Deep;

use my_inc '../../../..', for => 'api/t';

use API::Reports::DataRules qw/
    get_all_field_names
    get_all_operators
    get_all_report_types
    get_all_date_ranges
/;
use API::Test::Reports::Xsd qw/get_enum_values/;

# StrategyId should be removed in DIRECT-167293
my $excludedReports = { map {$_ => 1} qw /STRATEGY_PERFORMANCE_REPORT/};
my $excludedFields = { map {$_ => 1} qw/AvgEffectiveCpmBid CriteriaMod CriteriaIdMod CriterionMod CriterionIdMod StrategyId/};

cmp_deeply( [ get_enum_values( 'reports', 'FieldEnum' ) ], [grep {!exists $excludedFields->{$_}} @{get_all_field_names()}], 'FieldEnum' );
cmp_deeply( [ get_enum_values( 'reports', 'FilterOperatorEnum' ) ], get_all_operators(), 'FilterOperatorEnum' );
cmp_deeply( [ get_enum_values( 'reports', 'ReportTypeEnum' ) ], [grep {!exists $excludedReports->{$_}} @{get_all_report_types()}], 'ReportTypeEnum' );
cmp_deeply( [ get_enum_values( 'reports', 'DateRangeTypeEnum' ) ], get_all_date_ranges(), 'DateRangeTypeEnum' );
