#!/usr/bin/perl

use strict;
use warnings;
use utf8;

use Test::More tests => 11;
use Test::Exception;

BEGIN {
    use_ok('API::Units::Costs');
}

%API::Units::Costs::COSTS = (
    service => {
        test => {
            call     => 5,
            circle   => 1,
            triangle => 2,
        }
    }
);

throws_ok { API::Units::Costs->new() } qr/Bad service given/, 'API::Units::Costs->new without service';
throws_ok { API::Units::Costs->new('bad_service') } qr/Bad service given/, 'API::Units::Costs->new with bad service';

throws_ok { API::Units::Costs->new('service') } qr/Bad operation given/, 'API::Units::Costs->new without operation';
throws_ok { API::Units::Costs->new('service', 'bad_operation') } qr/Bad operation given/, 'API::Units::Costs->new with bad operation';

my $costs;
lives_ok { $costs = API::Units::Costs->new('service', 'test') } 'API::Units::Costs->new';

is $costs->get_cost_for_operation(), 5, 'API::Units::Costs->get_cost_for_operation';
is $costs->get_cost_for_objects(circle => 10), 10, 'API::Units::Costs->get_cost_for_objects for 10 circles';
is $costs->get_cost_for_objects(triangle => 5), 10, 'API::Units::Costs->get_cost_for_objects for 5 triangles';

is $costs->get_cost_for_objects(rectangle => 10), 0, 'API::Units::Costs->get_cost_for_objects for 10 rectangles';
is $costs->get_cost_for_objects('diamond'), 0, 'API::Units::Costs->get_cost_for_objects for diamonds';
