#!/usr/bin/perl

use utf8;
use strict;
use warnings;

use Test::More;

use API::Service::Base;

my $json = JSON->new->allow_nonref(1);


my $service = API::Service::Base->new();

$service->set_protocol('json');
ok(!defined $service->nil, 'json: nil is undef');
ok($service->is_nil(undef), 'json: is_nil(undef) true');

$service->set_protocol('soap');
ok($service->nil eq 'NIL', 'soap: nil is "NIL"');
ok($service->is_nil("NIL"), 'soap: is_nil("NIL") true');
ok(!$service->is_nil(undef), 'soap: is_nil(undef) false');

foreach my $proto (qw/json soap/) {
    $service->set_protocol($proto);
    foreach my $val (0, "0", "", "asdf", 'nil', 123) {
        ok(!$service->is_nil($val), "$proto: is_nil($val) false");
    }
}

done_testing;
