use Test::More tests => 4;

use warnings;
use strict;
use utf8;

use lib::abs;

use XML::Compile::Cache;
use Settings;
use API::WSDLFiles qw/wsdl_files xsd_definitions wsdl_directory/;

ok(-d wsdl_directory(5), 'wsdl files directory exists');

ok(my $xml_compile = XML::Compile::Cache->new, 'XML::Compile::Cache->new');

ok($xml_compile->importDefinitions(
    [ wsdl_files(5), xsd_definitions(5) ]
), 'schema files imported');

ok( $xml_compile->template(
        'XML',
        '{http://api.direct.yandex.com/v5/adgroups}GetResponse'
    ) =~ /NegativeKeywords/
    , 'schema seems interpreted'
);
