use Test::More;

use warnings;
use strict;
use utf8;

=pod

    $Id$

=head1 NAME

    wsdl_json_compatible.t

=head1 DESCRIPTION

    Проверяем что все WSDL-ли совместимы с нашей JSON валидацией, пока
    проверяет только для пятой версии апи, если структура не зименится то нужно
    добавлятье версии в @API_VERSIONS

=cut

use Settings;
use API::WSDLFiles qw/wsdl_files xsd_definitions/;
use API::Services;
use WSDL::JSON::Schema;

my @VERSIONS = qw/5/;

foreach my $version (@VERSIONS) {
    subtest "APIv$version" => sub {
        my $services = API::Services->new(
            [ wsdl_files($version) ],
            [ xsd_definitions($version) ]
        );

        my $nss = $services->namespaces;
        $services->map_thru_service_operation_ns_parts(sub {
            my ($service, $operation, $ns, $request, $response) = @_;
            my $schema = WSDL::JSON::Schema->new($nss, $ns);
            ok($schema->build($request), "v$version $service $operation request json schema builded");
            ok($schema->build($response), "v$version $service $operation response json schema builded");
        });
    }
}

done_testing;
