use Test::More tests => 14;

use warnings;
use strict;
use utf8;

my $ns_prefix = "http://direct.yandex.com/api/v5";

my $get_response_xml = '<?xml version="1.0" encoding="UTF-8"?>
<SOAP-ENV:Envelope xmlns:SOAP-ENV="http://schemas.xmlsoap.org/soap/envelope/"><SOAP-ENV:Body><ns:GetResponse xmlns:ns="http://direct.yandex.com/api/v5/adgroups" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"><AdGroups><RegionIds>10174</RegionIds><Id>84188117</Id><Status>ACTIVE</Status></AdGroups></ns:GetResponse></SOAP-ENV:Body></SOAP-ENV:Envelope>
';

use_ok('XML::LibXML'); #-2.0116
use_ok('XML::Compile::Cache');
use_ok('XML::Compile::SOAP');
use_ok('XML::Compile::SOAP11::Server');
use_ok('XML::Compile::WSDL11');

my $wsdl = '';
$wsdl .= $_ while(<DATA>);

my $wsdl11 = XML::Compile::WSDL11->new;
$wsdl11->addWSDL($wsdl);

ok(my $soap_server = XML::Compile::SOAP11::Server->new(schemas=>$wsdl11), 'creating soap server object');

ok(
    my $fault_sender = $soap_server->compileMessage('SENDER',
        header => [],
        body => [
            Fault => "{http://schemas.xmlsoap.org/soap/envelope/}Fault"
        ]
    )
    ,'fault sender'
);

my $detail = XML::LibXML::Element->new('detail');
$detail->setNamespace("$ns_prefix/fault_detail");
$detail->appendTextChild("error_code", 123);
$detail->appendTextChild("error_detail", 'Operation failed some how, it happens');

ok(
    $fault_sender->({
        faultcode => 'Server',
        faultstring => 'Operation failed',
        detail => {
            "{$ns_prefix/fault_detail}detail" => $detail
        }
    }, 'UTF-8')->toString eq '<?xml version="1.0" encoding="UTF-8"?>
<SOAP-ENV:Envelope xmlns:SOAP-ENV="http://schemas.xmlsoap.org/soap/envelope/"><SOAP-ENV:Body><SOAP-ENV:Fault><faultcode>Server</faultcode><faultstring>Operation failed</faultstring><detail><detail xmlns="http://direct.yandex.com/api/v5/fault_detail"><error_code>123</error_code><error_detail>Operation failed some how, it happens</error_detail></detail></detail></SOAP-ENV:Fault></SOAP-ENV:Body></SOAP-ENV:Envelope>
' , 'soap fault');

ok(my $sender = $soap_server->compileMessage('SENDER', header => [
        RequestHeader => "{$ns_prefix/general}RequestHeader"
    ],
    body => [
        GetResponse => "{$ns_prefix/adgroups}GetResponse"
    ]
), 'sender');

ok(my $reciever = $soap_server->compileMessage('RECEIVER', header => [
        RequestHeader => "{$ns_prefix/general}RequestHeader"
    ],
    body => [
        GetResponse => "{$ns_prefix/adgroups}GetResponse"
    ]
), 'reciever');

ok(my $data = $reciever->($get_response_xml), 'deserialized');

is_deeply($data, {
    'GetResponse' => {
        'AdGroups' => [
            {
                'Id' => '84188117',
                'Status' => 'ACTIVE',
                'RegionIds' => [
                    '10174'
                ]
            }
        ]
    }
}, 'deserialization');

ok(my $xml = $sender->($data, 'UTF-8'), 'serialized');

ok($xml->toString eq $get_response_xml, 'serialization');

__DATA__
<?xml version="1.0" encoding="UTF-8" standalone="no"?>
<wsdl:definitions xmlns:soap="http://schemas.xmlsoap.org/wsdl/soap/"
                  xmlns:ns="http://direct.yandex.com/api/v5/adgroups"
                  xmlns:general="http://direct.yandex.com/api/v5/general"
                  xmlns:wsdl="http://schemas.xmlsoap.org/wsdl/"
                  xmlns:xsd="http://www.w3.org/2001/XMLSchema"
                  name="AdGroups"
                  targetNamespace="http://direct.yandex.com/api/v5/adgroups">

    <wsdl:types>

        <xsd:schema targetNamespace="http://direct.yandex.com/api/v5/fault_detail">
            <xsd:element name="detail">
                <xsd:complexType>
                    <xsd:sequence>
                        <xsd:element name="error_code" type="xsd:int" nillable="false" minOccurs="1" maxOccurs="1"/>
                        <xsd:element name="error_detail" type="xsd:string" nillable="false" minOccurs="0" maxOccurs="1"/>
                    </xsd:sequence>
                </xsd:complexType>
            </xsd:element>
        </xsd:schema>

        <!-- general part start -->
        <xsd:schema targetNamespace="http://direct.yandex.com/api/v5/general">


            <xsd:element name="RequestHeader" type="general:SoapHeader"/>

            <xsd:complexType name="SoapHeader">
                <xsd:sequence>
                    <xsd:element name="token" type="xsd:string" minOccurs="1" maxOccurs="1"/>
                    <xsd:element name="locale" type="xsd:string" minOccurs="0" maxOccurs="1"/>
                    <xsd:element name="login" type="xsd:string" minOccurs="0" maxOccurs="1"/>
                </xsd:sequence>
            </xsd:complexType>

            <xsd:complexType name="ExceptionNotification">
                <xsd:sequence>
                    <xsd:element name="Code" type="xsd:int" minOccurs="1" maxOccurs="1"/>
                    <xsd:element name="Message" type="xsd:string" minOccurs="1" maxOccurs="1"/>
                    <xsd:element name="Details" type="xsd:string" minOccurs="0" maxOccurs="1"/>
                </xsd:sequence>
            </xsd:complexType>

            <xsd:complexType name="ActionResult">
                <xsd:sequence>
                    <xsd:element name="Id" type="xsd:long" minOccurs="0" maxOccurs="1"/>
                    <xsd:element name="Warnings" type="general:ExceptionNotification" minOccurs="0"
                                 maxOccurs="unbounded"/>
                    <xsd:element name="Errors" type="general:ExceptionNotification" minOccurs="0"
                                 maxOccurs="unbounded"/>
                </xsd:sequence>
            </xsd:complexType>

            <!-- for Page -->
            <xsd:complexType name="LimitOffset">
                <xsd:sequence>
                    <xsd:element name="Limit" type="xsd:long" minOccurs="0" maxOccurs="1"/>
                    <xsd:element name="Offset" type="xsd:long" minOccurs="0" maxOccurs="1"/>
                </xsd:sequence>
            </xsd:complexType>

            <xsd:simpleType name="YesNoEnum">
                <xsd:restriction base="xsd:string">
                    <xsd:enumeration value="YES"/>
                    <xsd:enumeration value="NO"/>
                </xsd:restriction>
            </xsd:simpleType>

            <xsd:simpleType name="StateEnum">
                <xsd:restriction base="xsd:string">
                    <xsd:enumeration value="ON"/>
                    <xsd:enumeration value="OFF"/>
                </xsd:restriction>
            </xsd:simpleType>

            <xsd:simpleType name="PriorityEnum">
                <xsd:restriction base="xsd:string">
                    <xsd:enumeration value="LOW"/>
                    <xsd:enumeration value="NORMAL"/>
                    <xsd:enumeration value="HIGH"/>
                </xsd:restriction>
            </xsd:simpleType>

            <xsd:simpleType name="PositionEnum">
                <xsd:restriction base="xsd:string">
                    <xsd:enumeration value="PREMIUMFIRST"/>
                    <xsd:enumeration value="PREMIUMBLOCK"/>
                    <xsd:enumeration value="FOOTERFIRST"/>
                    <xsd:enumeration value="FOOTERBLOCK"/>
                </xsd:restriction>
            </xsd:simpleType>

            <xsd:complexType name="IdsCriteria">
                <xsd:sequence>
                    <xsd:element name="Ids" type="xsd:long" minOccurs="1" maxOccurs="unbounded"/>
                </xsd:sequence>
            </xsd:complexType>

            <xsd:complexType name="GetRequestGeneral">
                <xsd:sequence>
                    <xsd:element name="Page" type="general:LimitOffset" minOccurs="0" maxOccurs="1"/>
                    <xsd:element name="FieldNames" type="xsd:string" minOccurs="1" maxOccurs="unbounded"/>
                </xsd:sequence>
            </xsd:complexType>

            <xsd:complexType name="GetResponseGeneral">
                <xsd:sequence>
                    <xsd:element name="LimitedBy" type="xsd:long" minOccurs="0" maxOccurs="1"/>
                </xsd:sequence>
            </xsd:complexType>

        </xsd:schema>
        <!-- / end of general part -->


        <xsd:schema targetNamespace="http://direct.yandex.com/api/v5/adgroups">

            <xsd:simpleType name="AdGroupStatusEnum">
                <xsd:restriction base="xsd:string">
                    <xsd:enumeration value="ACTIVE"/>
                    <xsd:enumeration value="EMPTY"/>
                    <xsd:enumeration value="ARCHIVED"/>
                    <xsd:enumeration value="REJECTED"/>
                </xsd:restriction>
            </xsd:simpleType>

            <xsd:complexType name="AdGroupsSelectionCriteria">
                <xsd:sequence>
                    <xsd:element name="CampaignIds" type="xsd:long" minOccurs="0" maxOccurs="unbounded"/>
                    <xsd:element name="Ids" type="xsd:long" minOccurs="0" maxOccurs="unbounded"/>
                    <xsd:element name="Statuses" type="ns:AdGroupStatusEnum" minOccurs="0" maxOccurs="unbounded"/>
                    <xsd:element name="TagIds" type="xsd:long" minOccurs="0" maxOccurs="unbounded"/>
                    <xsd:element name="Tags" type="xsd:string" minOccurs="0" maxOccurs="unbounded"/>
                </xsd:sequence>
            </xsd:complexType>

            <xsd:complexType name="AdGroupBase">
                <xsd:sequence>
                    <xsd:element name="Name" type="xsd:string" minOccurs="0" maxOccurs="1"/>
                    <xsd:element name="RegionIds" type="xsd:long" minOccurs="0" maxOccurs="unbounded"/>
                    <xsd:element name="MinusKeywords" type="xsd:string" minOccurs="0" maxOccurs="unbounded"
                                 nillable="true"/>
                </xsd:sequence>
            </xsd:complexType>

            <xsd:complexType name="AdGroupAddItem">
                <xsd:sequence>
                    <xsd:element name="Name" type="xsd:string" minOccurs="1" maxOccurs="1"/>
                    <xsd:element name="CampaignId" type="xsd:long" minOccurs="1" maxOccurs="1"/>
                    <xsd:element name="RegionIds" type="xsd:long" minOccurs="1" maxOccurs="unbounded"/>
                    <!-- not required, if specified but couldn't be empty -->
                    <xsd:element name="MinusKeywords" type="xsd:string" minOccurs="0" maxOccurs="unbounded"/>
                </xsd:sequence>
            </xsd:complexType>


            <xsd:complexType name="AdGroupGetItem">
                <xsd:complexContent>
                    <xsd:extension base="ns:AdGroupBase">
                        <xsd:sequence>
                            <xsd:element name="Id" type="xsd:long" minOccurs="0" maxOccurs="1"/>
                            <xsd:element name="Status" type="ns:AdGroupStatusEnum" minOccurs="0" maxOccurs="1"/>
                            <xsd:element name="StatusClarification" type="xsd:string" minOccurs="0" maxOccurs="1"
                                         nillable="true"/>
                        </xsd:sequence>
                    </xsd:extension>
                </xsd:complexContent>
            </xsd:complexType>

            <xsd:complexType name="AdGroupUpdateItem">
                <xsd:complexContent>
                    <xsd:extension base="ns:AdGroupBase">
                        <xsd:sequence>
                            <xsd:element name="Id" type="xsd:long" minOccurs="1" maxOccurs="1"/>
                        </xsd:sequence>
                    </xsd:extension>
                </xsd:complexContent>
            </xsd:complexType>

            <!-- Get operation in and our message types -->
            <xsd:element name="GetRequest">
                <xsd:complexType>
                    <xsd:complexContent>
                        <xsd:extension base="general:GetRequestGeneral">
                            <xsd:sequence>
                                <xsd:element name="SelectionCriteria" type="ns:AdGroupsSelectionCriteria" minOccurs="1"
                                             maxOccurs="1"/>
                            </xsd:sequence>
                        </xsd:extension>
                    </xsd:complexContent>
                </xsd:complexType>
            </xsd:element>

            <xsd:element name="GetResponse">
                <xsd:complexType>
                    <xsd:complexContent>
                        <xsd:extension base="general:GetResponseGeneral">
                            <xsd:sequence>
                                <xsd:element name="AdGroups" type="ns:AdGroupGetItem" minOccurs="0"
                                             maxOccurs="unbounded"/>
                            </xsd:sequence>
                        </xsd:extension>
                    </xsd:complexContent>
                </xsd:complexType>
            </xsd:element>
            <!-- / End of Get operation types -->

            <!-- Add operation types -->
            <xsd:element name="AddRequest">
                <xsd:complexType>
                    <xsd:sequence>
                        <xsd:element name="AdGroups" type="ns:AdGroupAddItem" minOccurs="1" maxOccurs="unbounded"/>
                    </xsd:sequence>
                </xsd:complexType>
            </xsd:element>

            <xsd:element name="AddResponse">
                <xsd:complexType>
                    <xsd:sequence>
                        <xsd:element name="AddResults" type="general:ActionResult" minOccurs="1" maxOccurs="unbounded"/>
                    </xsd:sequence>
                </xsd:complexType>
            </xsd:element>
            <!-- end of Add operation types -->

            <!-- Update operation types -->
            <xsd:element name="UpdateRequest">
                <xsd:complexType>
                    <xsd:sequence>
                        <xsd:element name="AdGroups" type="ns:AdGroupUpdateItem" minOccurs="1" maxOccurs="unbounded"/>
                    </xsd:sequence>
                </xsd:complexType>
            </xsd:element>

            <xsd:element name="UpdateResponse">
                <xsd:complexType>
                    <xsd:sequence>
                        <xsd:element name="UpdateResults" type="general:ActionResult" minOccurs="1"
                                     maxOccurs="unbounded"/>
                    </xsd:sequence>
                </xsd:complexType>
            </xsd:element>
            <!-- end of Update operation types -->

            <!-- Delete operation types -->
            <xsd:element name="DeleteRequest">
                <xsd:complexType>
                    <xsd:sequence>
                        <xsd:element name="SelectionCriteria" type="general:IdsCriteria" minOccurs="1" maxOccurs="1"/>
                    </xsd:sequence>
                </xsd:complexType>
            </xsd:element>

            <xsd:element name="DeleteResponse">
                <xsd:complexType>
                    <xsd:sequence>
                        <xsd:element name="DeleteResults" type="general:ActionResult" minOccurs="1"
                                     maxOccurs="unbounded"/>
                    </xsd:sequence>
                </xsd:complexType>
            </xsd:element>
            <!-- Delete operation types -->

        </xsd:schema>
    </wsdl:types>

    <wsdl:message name="RequestHeader">
        <wsdl:part element="general:RequestHeader" name="RequestHeader"/>
    </wsdl:message>

    <wsdl:message name="GetOperationRequest">
        <wsdl:part element="ns:GetRequest" name="parameters"/>
    </wsdl:message>

    <wsdl:message name="GetOperationResponse">
        <wsdl:part element="ns:GetResponse" name="parameters"/>
    </wsdl:message>

    <wsdl:message name="AddOperationRequest">
        <wsdl:part element="ns:AddRequest" name="parameters"/>
    </wsdl:message>

    <wsdl:message name="AddOperationResponse">
        <wsdl:part element="ns:AddResponse" name="parameters"/>
    </wsdl:message>

    <wsdl:message name="UpdateOperationRequest">
        <wsdl:part element="ns:UpdateRequest" name="parameters"/>
    </wsdl:message>

    <wsdl:message name="UpdateOperationResponse">
        <wsdl:part element="ns:UpdateResponse" name="parameters"/>
    </wsdl:message>

    <wsdl:message name="DeleteOperationRequest">
        <wsdl:part element="ns:DeleteRequest" name="parameters"/>
    </wsdl:message>

    <wsdl:message name="DeleteOperationResponse">
        <wsdl:part element="ns:DeleteResponse" name="parameters"/>
    </wsdl:message>

    <wsdl:portType name="AdGroupsPort">
        <wsdl:operation name="get">
            <wsdl:input message="ns:GetOperationRequest" name="getRequest"/>
            <wsdl:output message="ns:GetOperationResponse"/>
        </wsdl:operation>
        <wsdl:operation name="add">
            <wsdl:input message="ns:AddOperationRequest" name="addRequest"/>
            <wsdl:output message="ns:AddOperationResponse"/>
        </wsdl:operation>
        <wsdl:operation name="update">
            <wsdl:input message="ns:UpdateOperationRequest" name="updateRequest"/>
            <wsdl:output message="ns:UpdateOperationResponse"/>
        </wsdl:operation>

        <wsdl:operation name="delete">
            <wsdl:input message="ns:DeleteOperationRequest" name="deleteRequest"/>
            <wsdl:output message="ns:DeleteOperationResponse"/>
        </wsdl:operation>
    </wsdl:portType>


    <wsdl:binding name="AdGroupsSOAP" type="ns:AdGroupsPort">
        <soap:binding style="document" transport="http://schemas.xmlsoap.org/soap/http"/>
        <wsdl:operation name="get">
            <soap:operation soapAction="http://direct.yandex.com/api/v5/adgroups/get"/>
            <wsdl:input name="getRequest">
                <soap:header use="literal" part="RequestHeader" message="ns:RequestHeader"/>
                <soap:body use="literal"/>
            </wsdl:input>
            <wsdl:output>
                <soap:body use="literal"/>
            </wsdl:output>
        </wsdl:operation>

        <wsdl:operation name="add">
            <soap:operation soapAction="http://direct.yandex.com/api/v5/adgroups/add"/>
            <wsdl:input name="addRequest">
                <soap:header use="literal" part="RequestHeader" message="ns:RequestHeader"/>
                <soap:body use="literal"/>
            </wsdl:input>
            <wsdl:output>
                <soap:body use="literal"/>
            </wsdl:output>
        </wsdl:operation>

        <wsdl:operation name="update">
            <soap:operation soapAction="http://direct.yandex.com/api/v5/adgroups/update"/>
            <wsdl:input name="updateRequest">
                <soap:header use="literal" part="RequestHeader" message="ns:RequestHeader"/>
                <soap:body use="literal"/>
            </wsdl:input>
            <wsdl:output>
                <soap:body use="literal"/>
            </wsdl:output>
        </wsdl:operation>

        <wsdl:operation name="delete">
            <soap:operation soapAction="http://direct.yandex.com/api/v5/adgroups/delete"/>
            <wsdl:input name="deleteRequest">
                <soap:header use="literal" part="RequestHeader" message="ns:RequestHeader"/>
                <soap:body use="literal"/>
            </wsdl:input>
            <wsdl:output>
                <soap:body use="literal"/>
            </wsdl:output>
        </wsdl:operation>
    </wsdl:binding>

    <wsdl:service name="AdGroups">
        <wsdl:port binding="ns:AdGroupsSOAP" name="AdGroupsSOAP">
            <soap:address location="http://direct.yandex.com/api/v5/adgroups/"/>
        </wsdl:port>
    </wsdl:service>

</wsdl:definitions>
