<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet
        xmlns:wsdl="http://schemas.xmlsoap.org/wsdl/"
        xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
        xmlns:soap="http://schemas.xmlsoap.org/wsdl/soap/"
        xmlns:xsd="http://www.w3.org/2001/XMLSchema"
        exclude-result-prefixes="wsdl"
        version="1.0">

<!--    <xsl:import href="wsdl-util.xsl"/> -->
    <xsl:strip-space elements="*"/>
    <xsl:output method="text"/>



    <xsl:template name="namespace-uri-of-qname">
        <xsl:param name="qname"/>

        <xsl:if test="contains($qname,':')">
            <xsl:value-of select="namespace::*[name()=substring-before($qname,':')]"/>
        </xsl:if>
    </xsl:template>


    <xsl:template name="parse-complex-type">
        <xsl:param name="complext"/>
        <xsl:param name="tab" />

        <xsl:variable name="ttt3">
            <xsl:call-template name="local-name-of-qname">
                <xsl:with-param name="qname" select="$complext"/>
            </xsl:call-template>
        </xsl:variable>

        <xsl:text>/* </xsl:text> <xsl:value-of select="$ttt3"/> <xsl:text> */</xsl:text>
        <xsl:for-each select="key('compelexType', $ttt3)//xsd:sequence/xsd:element">

            <xsl:text>
</xsl:text>
            <xsl:text>      </xsl:text>
            <xsl:value-of select="$tab"/>

            <xsl:variable name="nestedClass" select="key('compelexType', substring-after(@type,':'))//xsd:sequence"/>

            <xsl:value-of select="@name" />
            <xsl:text>: </xsl:text>
            <xsl:if test="@maxOccurs = 'unbounded'">
                <xsl:text>[</xsl:text>
            </xsl:if>

            <xsl:if test="$nestedClass = ''">
                <xsl:text>{</xsl:text>
            </xsl:if>

            <xsl:variable name="type_name">
                <xsl:call-template name="parse-type">
                    <xsl:with-param name="qname" select="@type"/>
                </xsl:call-template>
            </xsl:variable>
            <xsl:value-of select="$type_name"/>


            <xsl:if test="$nestedClass = ''">
            <xsl:text>
       }</xsl:text>
            </xsl:if>
            <xsl:if test="@maxOccurs = 'unbounded'">

                <xsl:choose>
                    <xsl:when test="$nestedClass = ''">
                        <xsl:text>, ...
      ]</xsl:text>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:text>, ... ]</xsl:text>
                    </xsl:otherwise>

                </xsl:choose>

            </xsl:if>

            <xsl:choose>
                <xsl:when test="not(position() = last())">
                    <xsl:text>,</xsl:text>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:variable name="basetype" select="key('compelexType', $ttt3)//xsd:extension/@base"/>
                    <xsl:if test="$basetype != ''">
                        <xsl:text>,</xsl:text>
                    </xsl:if>
                </xsl:otherwise>

            </xsl:choose>

            <xsl:variable name="sep">

                <xsl:choose>
                    <xsl:when test="@nillable='true'">
                        <xsl:value-of select="true()"/>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:value-of select="false()"/>
                    </xsl:otherwise>
                </xsl:choose>

            </xsl:variable>


            <xsl:if test="@nillable='true'">
                <xsl:text> // nillable </xsl:text>


            </xsl:if>
            <xsl:if test="@minOccurs &gt; 0">
                <xsl:if test="$sep = 'false'">
                    <xsl:text> //</xsl:text>
                </xsl:if>
                <xsl:text> required </xsl:text>
            </xsl:if>

            <xsl:if test="position() = last()">
                <xsl:variable name="basetype" select="key('compelexType', $ttt3)//xsd:extension/@base"/>
                <xsl:if test="$basetype != ''">
                <xsl:text>
              </xsl:text>
 <!--                   <xsl:text>/*</xsl:text> <xsl:value-of select="substring-after($basetype,':')"/> <xsl:text> */</xsl:text> -->
                    <xsl:call-template name="parse-complex-type">
                        <xsl:with-param name="complext" select="$basetype"/>
                        <xsl:with-param name="tab" select="concat(' ', ' ')"/>
                    </xsl:call-template>
                </xsl:if>
            </xsl:if>
        </xsl:for-each>


    </xsl:template>


    <!-- Technique 2 -->

    <!-- emits a prefix that maps to the specified namespace uri for current() -->

    <xsl:template name="prefix-for-namespace">
        <xsl:param name="namespace-uri"/>

        <xsl:if test="$namespace-uri">
            <!-- terminate if current() does not have a prefix for $namespace-uri -->
            <xsl:if test="not(namespace::*[string() = $namespace-uri])">
                <xsl:message terminate="yes">
                    <xsl:text>Unable to find namespace prefix for namespace </xsl:text>
                    <xsl:value-of select="$namespace-uri"/>
                    <xsl:text> while processing </xsl:text>
                    <xsl:value-of select="name()"/>
                    <xsl:text> element.</xsl:text>
                </xsl:message>
            </xsl:if>

            <xsl:value-of select="name(namespace::*[string() = $namespace-uri])"/>
            <xsl:text>:</xsl:text>
        </xsl:if>

    </xsl:template>


    <!-- emits a prefix that maps to the wsdl:definitions/@targetNamespace -->

    <xsl:template name="prefix-for-target-namespace">
        <xsl:if test="/wsdl:definitions/@targetNamespace">
            <xsl:call-template name="prefix-for-namespace">
                <xsl:with-param name="namespace-uri">
                    <xsl:value-of select="/wsdl:definitions/@targetNamespace"/>
                </xsl:with-param>
            </xsl:call-template>
        </xsl:if>
    </xsl:template>


    <!-- Technique 3 -->

    <!-- emits the local name of the specified qname -->

    <xsl:template name="local-name-of-qname">
        <xsl:param name="qname"/>

        <xsl:choose>
            <xsl:when test="contains($qname,':')">
                <xsl:value-of select="substring-after($qname,':')"/>
            </xsl:when>

            <xsl:otherwise>
                <xsl:value-of select="$qname"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

    <xsl:template name="p1">
        <xsl:param name="qname"/>

        <xsl:variable name="nestedClass" select="key('compelexType', substring-after($qname,':'))//xsd:sequence"/>
        <xsl:variable name="tab1" select="concat(' ' , ' ')"/>
        <xsl:choose>
            <xsl:when test="$nestedClass = ''">

                <xsl:call-template name="parse-complex-type">
                    <xsl:with-param name="complext" select="$qname"/>
                    <xsl:with-param name="tab" select="$tab1" />
                </xsl:call-template>

            </xsl:when>
            <xsl:otherwise>
                <xsl:text>( </xsl:text>
                <xsl:for-each select="key('enumerationType',substring-after($qname,':'))//xsd:enumeration">
                    <xsl:value-of select="@value"/>
                    <xsl:if test="not(position() = last())">
                        <xsl:text> | </xsl:text>
                    </xsl:if>
                </xsl:for-each>
                <xsl:text>)</xsl:text>
            </xsl:otherwise>
        </xsl:choose>

    </xsl:template>


    <xsl:template name="parse-type">
        <xsl:param name="qname"/>


        <xsl:choose>
            <xsl:when test="starts-with($qname, 'general:')">
                <xsl:call-template name="p1">
                    <xsl:with-param name="qname" select="$qname"/>
                </xsl:call-template>
            </xsl:when>
            <xsl:when test="starts-with($qname, 'ns:')">
                <xsl:call-template name="p1">
                    <xsl:with-param name="qname" select="$qname"/>
                </xsl:call-template>
            </xsl:when>
            <xsl:when test="contains($qname,':')">
                <xsl:text>(</xsl:text>
                <xsl:value-of select="substring-after($qname,':')"/>
                <xsl:text>)</xsl:text>
            </xsl:when>

            <xsl:otherwise>
                <xsl:text>(</xsl:text>
                <xsl:value-of select="$qname"/>
                <xsl:text>)</xsl:text>
            </xsl:otherwise>
        </xsl:choose>

    </xsl:template>



    <!-- Technique 4 -->

    <!-- index of wsdl:message by namespace uri, wsdl:message/@name -->

    <xsl:key name="message"
             match="wsdl:message"
             use="concat(/wsdl:definitions/@targetNamespace,' ',@name)"/>


    <!-- message key value that corresponds to a
         wsdl:portType/wsdl:operation/wsdl:* -->

    <xsl:template match="wsdl:portType/wsdl:operation/wsdl:input |
                     wsdl:portType/wsdl:operation/wsdl:output |
                     wsdl:portType/wsdl:operation/wsdl:fault"
                  mode="message-key">
        <xsl:call-template name="namespace-uri-of-qname">
            <xsl:with-param name="qname" select="@message"/>
        </xsl:call-template>

        <xsl:text> </xsl:text>

        <xsl:call-template name="local-name-of-qname">
            <xsl:with-param name="qname" select="@message"/>
        </xsl:call-template>
    </xsl:template>


    <xsl:template match="wsdl:part"
                  mode="element-key">
        <!--     <xsl:call-template name="namespace-uri-of-qname">
                 <xsl:with-param name="qname" select="@element"/>
             </xsl:call-template>

             <xsl:text> </xsl:text>
     -->
        <xsl:call-template name="local-name-of-qname">
            <xsl:with-param name="qname" select="@element"/>
        </xsl:call-template>
    </xsl:template>


    <xsl:key name="element"
             match="wsdl:types/xsd:schema/xsd:element"
             use="@name"/>


    <xsl:key name="compelexType" match="wsdl:types/xsd:schema/xsd:complexType" use="@name"/>

    <xsl:key name="enumerationType" match="wsdl:types/xsd:schema/xsd:simpleType" use="@name"/>

    <!-- Technique 5 -->


    <!-- index of wsdl:portType by namespace uri, wsdl:portType/@name -->

    <xsl:key name="porttype"
             match="wsdl:portType"
             use="concat(/wsdl:definitions/@targetNamespace,' ',@name)"/>


    <!-- porttype key that corresponds to a wsdl:binding -->

    <xsl:template match="wsdl:binding"
                  mode="porttype-key">
        <xsl:call-template name="namespace-uri-of-qname">
            <xsl:with-param name="qname" select="@type"/>
        </xsl:call-template>

        <xsl:text> </xsl:text>

        <xsl:call-template name="local-name-of-qname">
            <xsl:with-param name="qname" select="@type"/>
        </xsl:call-template>
    </xsl:template>


    <!-- Technique 6 -->

    <!-- index of wsdl:binding by namespace uri and wsdl:binding/@name -->

    <xsl:key name="binding" match="wsdl:binding"
             use="concat(/wsdl:definitions/@targetNamespace,' ',@name)"/>


    <!-- binding key value for wsdl:port -->

    <xsl:template match="wsdl:port" mode="binding-key">
        <xsl:call-template name="namespace-uri-of-qname">
            <xsl:with-param name="qname" select="@binding"/>
        </xsl:call-template>

        <xsl:text> </xsl:text>

        <xsl:call-template name="local-name-of-qname">
            <xsl:with-param name="qname" select="@binding"/>
        </xsl:call-template>
    </xsl:template>




    <!-- just process the services -->
    <xsl:template match="wsdl:definitions">
        <xsl:apply-templates select="wsdl:service"/>
    </xsl:template>


    <!-- dump out some information for each service -->
    <xsl:template match="wsdl:service">
        <xsl:text>service: </xsl:text>
        <xsl:value-of select="@name"/>
 <xsl:text>  </xsl:text>
        <xsl:apply-templates select="wsdl:port/soap:address"/>
 <xsl:text>
</xsl:text>


        <xsl:apply-templates select="wsdl:port"/>
    </xsl:template>

    <xsl:template match="soap:address">
           <xsl:text>wsdl: </xsl:text>
           <xsl:value-of select="@location"/>
    </xsl:template>

    <!-- follow the linkages from the wsdl:port through the
         wsdl:binding, back to the wsdl:portType and its
         wsdl:operations -->
    <xsl:template match="wsdl:port">

        <!-- key for looking up the wsdl:binding -->
        <xsl:variable name="binding-key">
            <xsl:apply-templates select="." mode="binding-key"/>
        </xsl:variable>

        <xsl:for-each select="key('binding',$binding-key)">
            <!-- key for looking up the wsdl:portType -->
            <xsl:variable name="porttype-key">
                <xsl:apply-templates select="." mode="porttype-key"/>
            </xsl:variable>

            <!-- process each operation in the wsdl:portType -->
            <xsl:for-each select="key('porttype',$porttype-key)/wsdl:operation">
                <xsl:apply-templates select="." mode="java"/>
            </xsl:for-each>

            <xsl:text>
</xsl:text>
            <xsl:text>
</xsl:text>
            <xsl:text>
</xsl:text>

            <!-- process each operation in the wsdl:portType with transform to json-->
            <xsl:for-each select="key('porttype',$porttype-key)/wsdl:operation">
                <xsl:apply-templates select="." mode="json"/>
            </xsl:for-each>

        </xsl:for-each>


    </xsl:template>



    <!-- generate a JSON-like method signature for each operation -->
    <xsl:template match="wsdl:portType/wsdl:operation" mode="json">

Input parameters:

        <xsl:text>
</xsl:text>
        <xsl:text>{</xsl:text>
        <xsl:text>  Action: </xsl:text>
        <xsl:value-of select="@name"/>
        <xsl:text>,</xsl:text>
<xsl:text>
</xsl:text>

        <!-- Input parameters -->

        <xsl:for-each select="wsdl:input">
            <xsl:text>   </xsl:text>
            <!-- get the correct value for the message name key -->
            <xsl:variable name="input-message-key">
                <xsl:apply-templates select="." mode="message-key"/>
            </xsl:variable>

            <!-- output the type of the type and name of each part of
                 the message -->
            <xsl:for-each select="key('message',$input-message-key)/wsdl:part">

                <xsl:if test="not(@type)">

<!--
                    <xsl:call-template name="local-name-of-qname">
                        <xfs sl:with-param name="qname" select="@element"/>
                    </xsl:call-template>

                <xsl:apply-templates select="." mode="element-key"/>
-->

                    <xsl:variable name="element-key">
                        <xsl:apply-templates select="." mode="element-key"/>
                    </xsl:variable>


                    <xsl:for-each select="key('element',$element-key)/xsd:complexType//xsd:sequence/xsd:element">
                        <xsl:apply-templates select="." mode="wrapper"/>
                    </xsl:for-each>

                    <xsl:for-each select="key('element',$element-key)/xsd:complexType//xsd:extension">
                        <xsl:variable name="basetype" select="./@base"/>
                        <xsl:text>,
</xsl:text>              <xsl:call-template name="parse-complex-type">
                            <xsl:with-param name="complext" select="$basetype"/>
                        </xsl:call-template>
                    </xsl:for-each>


                </xsl:if>
                <xsl:if test="not(last())">
                    <xsl:text>}, </xsl:text>
                </xsl:if>
            </xsl:for-each>

        </xsl:for-each>

        <xsl:text>
</xsl:text>

                <xsl:text>}
</xsl:text>
<xsl:text>
</xsl:text>

Output values:
<xsl:text>

</xsl:text>

        <xsl:for-each select="wsdl:output">
            <xsl:text>   </xsl:text>
            <!-- get the correct value for the message name key -->
            <xsl:variable name="input-message-key">
                <xsl:apply-templates select="." mode="message-key"/>
            </xsl:variable>

            <!-- output the type of the type and name of each part of
                 the message -->
            <xsl:for-each select="key('message',$input-message-key)/wsdl:part[1]">

                <xsl:if test="not(@type)">

                    <!--
                                        <xsl:call-template name="local-name-of-qname">
                                            <xfs sl:with-param name="qname" select="@element"/>
                                        </xsl:call-template>

                                    <xsl:apply-templates select="." mode="element-key"/>
                    -->
                    <xsl:variable name="element-key">
                        <xsl:apply-templates select="." mode="element-key"/>
                    </xsl:variable>


                    <xsl:for-each select="key('element',$element-key)/xsd:complexType//xsd:sequence/xsd:element">
                        <xsl:apply-templates select="." mode="wrapper"/>
    <!--                    <xsl:text> count :</xsl:text>
                        <xsl:value-of select="count($element-key)"/>
                        <xsl:text> pos :</xsl:text>
                        <xsl:value-of select="position()"/>
                        <xsl:value-of select="last()"/>
                        -->
                        <xsl:if test="position() != last()">
<xsl:text>,
   </xsl:text>
                        </xsl:if>

                    </xsl:for-each>

                </xsl:if>
                <xsl:if test="not(last())">
                    <xsl:text>}, </xsl:text>
                </xsl:if>
            </xsl:for-each>

        </xsl:for-each>

        <xsl:text>
</xsl:text>


    </xsl:template>

    <xsl:template match="xsd:element" mode="wrapper">
        <xsl:value-of select="@name"/><xsl:variable name="type" select="@type"/>
        <xsl:text>: </xsl:text>
    <!--  <xsl:text> /* </xsl:text>  <xsl:value-of select="$type"/>  <xsl:text> */</xsl:text>-->



     <xsl:variable name="array">
            <xsl:value-of select="@maxOccurs"/>
     </xsl:variable>

        <xsl:if test="$array = 'unbounded'">
            <xsl:text> [</xsl:text>
        </xsl:if>
        <xsl:choose>
            <xsl:when test="starts-with($type,'xsd:')">
               <xsl:text>(</xsl:text> <xsl:value-of select="substring-after($type,':')"/>  <xsl:text>)</xsl:text>
            </xsl:when>
            <xsl:otherwise>
                <xsl:text>{ </xsl:text>

                <xsl:text> </xsl:text>


                <xsl:call-template name="parse-complex-type">
                    <xsl:with-param name="complext" select="@type"/>
                </xsl:call-template>

                <xsl:text> </xsl:text>
        <xsl:text>
</xsl:text>
                <xsl:text>   }</xsl:text>

            </xsl:otherwise>
        </xsl:choose>


        <xsl:choose>
            <xsl:when test="$array = 'unbounded'" >
                <xsl:text>]</xsl:text>
        </xsl:when>
        </xsl:choose>
<!--
            <xsl:text>, / </xsl:text> <xsl:value-of select="position()"/> <xsl:text>
   </xsl:text>
-->

    </xsl:template>



    <!-- generate a Java-like method signature for each operation -->
    <xsl:template match="wsdl:portType/wsdl:operation" mode="java">

        <xsl:text>  </xsl:text>

        <!-- return type -->
        <xsl:for-each select="wsdl:output">

            <!-- get the correct value for the message name key -->
            <xsl:variable name="output-message-key">
                <xsl:apply-templates select="." mode="message-key"/>
            </xsl:variable>

            <!-- output the type of the first part of the message -->
            <xsl:for-each
                    select="key('message',$output-message-key)/wsdl:part[1]">
                <xsl:if test="not(@type)">
                    <xsl:call-template name="local-name-of-qname">
                        <xsl:with-param name="qname" select="@element"/>
                    </xsl:call-template>

                </xsl:if>
                <xsl:value-of select="@type"/>
            </xsl:for-each>

        </xsl:for-each>

        <xsl:if test="not(wsdl:output)">
            <xsl:text>void</xsl:text>
        </xsl:if>


        <!-- method name -->
        <xsl:text> </xsl:text>
        <xsl:value-of select="@name"/>


        <!-- arguments -->
        <xsl:text>(</xsl:text>
        <xsl:for-each select="wsdl:input">

            <!-- get the correct value for the message name key -->
            <xsl:variable name="input-message-key">
                <xsl:apply-templates select="." mode="message-key"/>
            </xsl:variable>

            <!-- output the type of the type and name of each part of
                 the message -->
            <xsl:for-each select="key('message',$input-message-key)/wsdl:part">

                <xsl:if test="not(@type)">
                    <xsl:call-template name="local-name-of-qname">
                        <xsl:with-param name="qname" select="@element"/>
                    </xsl:call-template>
                </xsl:if>
                <xsl:value-of select="@type"/>
                <xsl:text> </xsl:text>
                <xsl:value-of select="@name"/>
                <xsl:if test="not(last())">
                    <xsl:text>, </xsl:text>
                </xsl:if>
            </xsl:for-each>

        </xsl:for-each>
        <xsl:text>)</xsl:text>


        <!-- exceptions -->
        <xsl:if test="wsdl:fault">
            <xsl:text> throws </xsl:text>
            <xsl:for-each select="wsdl:fault">

                <!-- get the correct value for the message name key -->
                <xsl:variable name="fault-message-key">
                    <xsl:apply-templates select="." mode="message-key"/>
                </xsl:variable>

                <xsl:for-each select="key('message',$fault-message-key)">
                    <xsl:value-of select="@name"/>
                </xsl:for-each>

                <xsl:if test="not(last())">
                    <xsl:text>, </xsl:text>
                </xsl:if>

            </xsl:for-each>
        </xsl:if>

    <xsl:text>;
</xsl:text>

    </xsl:template>

</xsl:stylesheet>