#!/usr/bin/perl

=head1 NAME
    
    copy_mysql_grants.pl - копирование прав во всех базах mysql, прописанных в Settings.pm

=head1 SINOPSIS

    # показать запросы, копирующие права user@...23 в user@...24
    copy_mysql_grants.pl 123.23.43.23 123.23.43.24
    # скопировать права
    DOIT=1 copy_mysql_grants.pl 123.23.43.23 123.23.43.24
    
=head1 DESCRIPTION
    
    получает из Settings.pm базы и хосты, ходит по ssh, копирует права

    Если для базы указано несколько хостов (пример: ppclog в Директе), обрабатывается только первый из них.
    Предполагается, что в таких случаях настроена репликация, и на остальные хосты права доедут по ней.

=cut    

use strict;
use warnings;

use my_inc '..';

use Yandex::Shell;

use Settings;
use Yandex::DBTools;

if (@ARGV != 2 || (grep {/^\d+\.\d+\.\d+\.\d+$/} @ARGV) != 2) {
    die "Usage: $0 ip1 ip2\n";
}

my ($ip_from, $ip_to) = @ARGV;

my %dbnames = map {$_ => 1} @{get_db_childs('', recursive => 1)};
for my $key (sort keys %dbnames) {
    print "$key\n";
    if ($key =~ /^(.*):(.*)$/ && exists $dbnames{$1}) {
        print "  skip - not master\n";
    }
    my $cfg = get_db_config($key);
    my $mysql = "mysql -u root -S /var/run/mysqld.$cfg->{instance}/mysqld.sock";
    my $host = ref $cfg->{host} eq 'ARRAY' ? $cfg->{host}->[0] : $cfg->{host};
    my $grants = eval {
        yash_qx("ssh", $host, qq!$mysql -BN -e 'SHOW GRANTS FOR $cfg->{user}\@$ip_from'!);
    };
    if ($@) {
        print "  skip - $@\n";
        next;
    }
    $grants =~ s/\Q$ip_from\E/$ip_to/g;
    $grants =~ s/\n/;\n/g;
    $grants =~ s/`//g;
    print "$grants\n";
    if ($ENV{DOIT}) {
        yash_system("ssh", $host, "$mysql -BN -e ".yash_quote($grants));
    }
}
