#!/usr/bin/perl
# Получить тикет для запроса от Директа к произвольному TVM-приложению
# Параметры:
#    --src -- символическое имя приложения из %Settings::TVM2_APP_ID (например: api)
#    --dst -- цифровой id приложения или символическое имя, как в --src

use strict;
use warnings;

use utf8;

use open qw/:std :encoding(UTF-8)/;

use Getopt::Long;

use my_inc '..';
use Settings;
use Yandex::TVM2;

my $src;
my $dst;
GetOptions(
    'src=s' => \$src,
    'dst=s' => \$dst,
) || die "can't parse options, stop\n";
my $known_apps_str = join(", ", sort keys %Settings::TVM2_APP_ID);
if (!$src) {
    die "no src app given, should be one of: $known_apps_str\n";
}
if (!$dst) {
    die "no dst app given, should be numeric ID or one of: $known_apps_str\n";
}
if (!exists $Settings::TVM2_APP_ID{$src}) {
    die "unknown src app name $src, should be one of: $known_apps_str\n";
}
$Yandex::TVM2::APP_ID = $Settings::TVM2_APP_ID{$src};
$Yandex::TVM2::SECRET_PATH = $Settings::TVM2_SECRET_PATH{$src};
if ($dst !~ /^[0-9]+$/) {
    $dst = $Settings::TVM2_APP_ID{$dst} || die "unknown dst app $dst, should be numeric ID or one of: $known_apps_str\n";
}
print Yandex::TVM2::get_ticket($dst);
