#!/usr/bin/perl

=head1 NAME

    settings-graph.pl - вывод графа иерархии Settings*.pm

=head1 DESCRIPTION

    Опции:
    --help - справка

=cut

use strict;
use warnings;

use Encode;
use Path::Tiny;
use Data::Dumper;
use Term::ANSIColor qw/colored/;

use my_inc '..';

my $DIR = shift || my_inc::path('../perl/settings');

my $graph = get_settings_graph($DIR);
my $local_settings = get_local_settings($DIR);

if (eval {require Graph::Easy; 1}) {
    print_with_graph_easy($graph, $local_settings);
} else {
    print Dumper $graph;
    #print_graph($graph, $local_settings);
}

sub _name {
    my $name = shift;
    if ($name eq 'Settings.pm') {
        return '_prod_';
    } elsif ($name =~ /(?:^|\/)Settings(\w+).pm/) {
        return $1;
    } else {
        return $name;
    }
}

sub get_settings_graph {
    my $dir = shift;
    my @files = path($dir)->children(qr/^Settings(?!Local|ALL)(?:.+).pm$/);

    my %data;
    for my $f (@files) {
        my @parents = $f->slurp_utf8 =~ /^\s*do\s*['"](Settings(?!Local|ALL)(?:.+).pm)['"]/mg;
        if (!@parents) {
            $data{_name('Settings.pm')}->{_name($f)} = 1;
        } else {
            for my $p (@parents) {
                $data{_name($p)}->{_name($f)} = 1;
            }
        }
    }
    return \%data;
}

sub get_local_settings {
    my ($dir) = @_;
    if (-l "$dir/SettingsLocal.pm") {
        return _name(readlink("$DIR/SettingsLocal.pm"));
    } else {
        return undef;
    }
}

sub print_with_graph_easy {
    my ($data, $local_settings) = @_;
    my $graph = Graph::Easy->new();
    while(my ($p, $cs) = each %$data) {
        $graph->add_edge($p, $_) for keys %$cs;
    }
    my $text = $graph->as_boxart();
    $text =~ s/(_prod_)/colored($1, "red")/e;
    if ($local_settings) {
        $text =~ s/( \Q$local_settings\E )/colored($1, "yellow")/e;
    }
    print Encode::encode_utf8($text);
}

