(function($, Lego) {
    Lego.block['b-add-agency'] = function(params) {
        var $this = $(this);

        var fields = {};
        var fieldNames = ['name', 'phone', 'url', 'email', 'country', 'city', 'geo_id'];
        var warnings = {
            'name': iget('Не указано имя агентства'),
            'phone': iget('Не указан телефон'),
            'url': iget('Не заполнено поле WEB'),
            'email': iget('Не указан E-mail'),
            'invalid_email': iget('Неверно указан E-mail'),
            'country': iget('Не указана страна'),
            'city': iget('Не указан город'),
            'geo_id': iget('Неправильно введено название города')
        };

        var agencyFind = $this.find('input.agency-find'),
            agencyCreate = $this.find('input.agency-create');

        agencyCreate.click(check);

        for (var i = 0; i < fieldNames.length; i++) {
            var field = $this.find('[name=' + fieldNames[i] + ']');
            if (field.length > 0) {
                fields[fieldNames[i]] = field;
            }

        }

        function check(e) {
            var errors = '';
            var emptyArray = [];
            for (var name in fields) {
                if (direct.utils.isEmpty(fields[name].val())) {
                    emptyArray.push(name);
                    if (name != 'geo_id' || $.inArray('city', emptyArray) == -1) {
                        errors += (errors) ? '\n' + warnings[name] : warnings[name];
                    }                    
                }
            }

            if (($.inArray('email', emptyArray) == -1) && !direct.utils.validateEmail(fields['email'].val())) {
                errors +=  (errors) ? '\n' + warnings['invalid_email'] : warnings['invalid_email'];
            }
            if (errors) { alert(errors); return false; }
            return confirm(iget('Вы уверены, что хотите создать новое агентство?'));
        }

    };
})(jQuery, window.Lego);
