BEM.DOM.decl('b-adv-alert-change', {
    onSetMod: {
        js: function() {
            this
                .bindTo('link', 'click', function(e) {
                    var bid = $(e.target).attr('bid');

                    this.domElem.find('.ddd-' + bid).toggle();
                    change_ad_warnings_link(bid, this.domElem);
                })
                .bindTo('item', 'click', function(e) {
                    var elem = $(e.target),
                        name = elem.attr('name'),
                        key = elem.attr('key'),
                        id = elem.attr('id'),
                        value = elem.attr('value');

                    change_ad_warning(key, id, value);
                });
        }
    }
});

BEM.HTML.decl('b-adv-alert-change', {
    onBlock: function(ctx) {
        var bid = ctx.param('bid'),
            warnings = ctx.param('warnings'),
            adWarnings = ctx.param('ad-warnings') || [],
            hashFlags = ctx.param('hash_flags');

        ctx
            .js(true)
            .content([
                {
                    tag: 'input',
                    attrs: { type: 'hidden', name: 'showed_warns-' + bid, value: '1' }
                },
                {
                    block: 'b-pseudo-link',
                    mix: [{ block: 'b-adv-alert-change', elem: 'link' }],
                    cls: 'href-' + bid,
                    attrs: { bid: bid },
                    content: warnings.length ?
                        iget('Изменить предупреждение') :
                        iget('Добавить предупреждение')
                },
                {
                    cls: 'ad-warns-' + bid + ' ' + 'ddd-' + bid,
                    attrs: {
                        style: 'display: none;'
                    },
                    content: $.map(adWarnings, function(value, key) {
                        var val = hashFlags[key];

                        if ($.inArray(key, ['age', 'tragic', 'telecom']) !== -1) {
                            return undefined;
                        }

                        if (key === 'baby_food' && !val) {
                            val = adWarnings[key]['default'];
                        }

                        return {
                            elem: 'item',
                            id: bid,
                            name: key,
                            displayName: adWarnings[key].short_text,
                            value: val,
                            checked: hashFlags[key]
                        };
                    })
                }
            ])
    },

    onElem: {
        item: function(ctx) {
            var name = ctx.param('name'),
                value = ctx.param('value'),
                id = ctx.param('id'),
                checked = ctx.param('checked'),
                displayName = ctx.param('displayName'),
                checkboxName = 'warn_' + name + '-' + id,
                attrs = {
                    type: 'checkbox',
                    name: checkboxName,
                    id: id,
                    key: name,
                    value: '1'
                };

            if (checked) {
                attrs.checked = 'checked'
            }

            ctx.content({
                cls: 'b-adv-alert__change__flags',
                content: [
                    {
                        tag: 'input',
                        cls: 'cwarns ' + checkboxName,
                        attrs: attrs
                    },
                    {
                        tag: 'label',
                        attrs: { 'for': checkboxName },
                        content: displayName
                    }
                ]
            });
        }
    }
});
