(function($, Lego) {
    Lego.block['b-advanced-forecast'] = function(params) {
        var $this = $(this),
            form = this[0],
            model = params.model,
            $doc = $(document),

            phrasesTextarea = form['phrases'],
            submitButton = $this.find(".b-advanced-forecast__submit-button")[0],
            wordSuggestions = $this.find(".b-word-suggestions"),

            keywordsHeader = $this.find(".js-keywords-header"),
            regionSelectorHeader = $this.find(".js-region-selector-header"),
            forecastParamsHeader = $this.find(".js-forecast-params-header"),

            currencyNodes = $('.b-advanced-forecast__currency'),

            // в рамках DIRECT-15894 оторвали уникальную для прогнозатора
            // функциональность при переключении языка (с сохранением данных)



            isFormSubmitted = false,

            noticeBefore = $this.find(".js-advanced-forecast-notice-before"),
            noticeAfter = $this.find(".js-advanced-forecast-notice-after"),

            AJAX_TIMEOUT_PERIOD = 3 * 60 * 1000,
            phraseValidationMessage = '',
            sumsClicksShowsAreCalculatedAtLeastOnce = false,

            keywordsRE = new RegExp("^[" + ALLOW_LETTERS + " ()|«»\"+!-" + "]*$");

        setTimeout(restorePrevState, 1000);

        model.unglue = 1;
        $("#b-advanced-forecast__unglue-checkbox").click(function(){ model.unglue = +!!this.checked });

        model.fixate_stopwords = 1;
        $("#b-advanced-forecast__fixate-stopwords-checkbox").click(function(){ model.fixate_stopwords = +!!this.checked });

        $this.bind('submit', function(e){ e.preventDefault(); submitForm(); });


        $doc
            // when block with slider becomes visible we should update section headers
            .bind('calculated-expense.visible', updateHeaders)
            // external block may ask to calculate forecast -- so we just submit form in such cases
            .bind('recalculate.phrases', function(){
                submitForm(true);
            });

        // when forecast options are modified in popup -- forecast is supposed to be recalculated
        // for the list of properties causing recalculation
        // see getDataForBudgetForecastParams in advanced-forecast/model.js
        model
            .bind('change.transitions-by-phrases-params', onTransitionsByPhrasesChange)
            .bind('change.window_phrases', onWindowPhrasesChange)
            .bind('change.forecastCurrency', changeCurrencyTitles);

        // restoring Advanced Forecast page state from the data which is stored in model
        // take a look at advanced_forecast.html
        // that's where model is populated with prev state date provided that the latter is passed
        function restorePrevState() {
            if (!model.previousState || !model.previousState.choosed_phrases) return;
            var prevPhrases = model.previousState.choosed_phrases.split(',');
            $.each(prevPhrases, function(index, phrase){
                wordSuggestions.data('api').addPhrase(phrase);
            });
            FORECAST_MODE = model.previousState.forecast_type || FORECAST_MODE;
            // some sort of dirty assumption that Budget By Positions tabs is the fitst one
            $this.find('.b-advanced-forecast__expense-tabs .b-tabs').data('api').selectedIndex(FORECAST_MODE == DISTRIBUTED ? 1 : 0, true);
            submitForm();
        }

        function addHiddenInput(form, name, value) {
            var input = document.createElement('input');

            input.name = name;
            input.setAttribute('type', 'hidden');
            input.value = value;

            form.appendChild(input);
        }

        function onTransitionsByPhrasesChange() {
            // the change of forecast options should cause further calculation only if the form has been submitted before
            if (isEmpty() || !isFormSubmitted) return;
            getDataForBudgetForecast();
        }

        function onWindowPhrasesChange() {
            if (!model.window_phrases.length) wordSuggestions.data('api').update();
        }

        function updateHeaders() {
            updateHeader(forecastParamsHeader, iget('Параметры расчета:'));
            updateHeader(regionSelectorHeader, iget('Регион показа:'));
            updateKeywordsHeader();
        }

        function updateHeader(headerNode, newTitle) {
            var header = headerNode.text();
            // using this hack since JavaScript doesn't have lookbehind in regexp.
            var newHeader = header.replace(/([0-9].\s).*/g, function($0, $1){
                return $1 ? $1 + newTitle : $0;
            });
            headerNode.text(newHeader);
        }

        function updateKeywordsHeader() {
            var header = keywordsHeader.text();
            var newHeader = header.replace(/^[0-9]/, function(n) {
                return ++n;
            });
            keywordsHeader.text(newHeader);
            updateHeader(keywordsHeader, iget('Новые ключевые фразы:'));
        }

        function getAllPhrases() {
            return wordSuggestions.data('api').getAllPhrases().join(',');
        }

        function submitForm(formChanged) {
            if (!formChanged && isEmpty()) {
                alert(iget("Фразы не заданы"));
                return;
            }

            var invalidKeyWord = getInvalidKeyword();
            if (!!invalidKeyWord.length) {
                alert(iget('В тексте ключевых фраз разрешается использовать только буквы английского, турецкого, казахского, русского, украинского или белорусского алфавита, кавычки, апостроф, знаки "-", "+", "!", пробел. Ошибка в ключевой фразе "%s"', invalidKeyWord));
                return;
            }

            if (formChanged || isFormChanged()) {
                isFormSubmitted = true;
                getDataForBudgetForecast();
            } else {
                alert(iget("Новые ключевые фразы/единые минус-фразы не заданы"));
            }
        }

        function isFormChanged() {
            var textareaPhrases = wordSuggestions.data('api').getPhrases();
            var arePhrasesChanges = !!textareaPhrases.length;

            var minusWords = $.trim(model.minus_words());
            var popupMinusWords = $.trim(model.popup_minus_words || "");
            var areMinusWordsChanged = minusWords != popupMinusWords;


            return arePhrasesChanges || areMinusWordsChanged;
        }


        function getMinusWords() {
            return BEM.blocks['i-utils'].minusWordsStringToArray(model.minus_words());
        }

        function getDataForBudgetForecast() {
            if (isEmpty()) {
                model.setEmptyValues();
                return;
            }


            var reqData = {
                'cmd': 'ajaxDataForNewBudgetForecast',
                'advanced_forecast': 'yes',
                'period': model.forecastPeriodType,
                'period_num': model.forecastPeriod,
                'phrases': getAllPhrases(),
                'json_minus_words': JSON.stringify(getMinusWords()),
                'geo': BEM.blocks['i-models-manager'].get('campaign&banner:0', 'b-regions-tree').get('geo') || 0,
                unglue: model.unglue,
                fixate_stopwords: model.fixate_stopwords
            };


            if (model.forecastPlatform == 'mobile') {
                reqData.is_mobile = 1;
            }

            if (model.forecastCurrency) {
                reqData.currency = model.forecastCurrency;
            }

            $.ajax({
                type: 'POST',
                dataType: 'json',
                url: params.ajaxURL,
                data: reqData,
                beforeSend: function() {
                    if (!beforeForecastCalculationCheck()) return false;
                    notifyAboutForecastDataCalculationBegining();
                },
                error: function(xhr, textStatus, e) {
                    notifyAboutForecastDataCalculationError();
                    alert(iget("Произошла ошибка. Попробуйте произвести расчет ещё раз."))
                },
                success: function(rData, textStatus, xhr) {
                    // нужно рассчитать поле sum по amnesty_price и кликам с
                    // приведением amnesty_price к нормализованному значению
                    // @see https://st.yandex-team.ru/DIRECT-44979
                    // так как сырое значение поля sum больше
                    rData.data_by_positions && rData.data_by_positions.forEach(function(position) {

                        // Приводим данные к старому формату для DIRECT-50238
                        var positions = position.positions;

                        Object.keys(positions).forEach(function(key) {
                            var pos = positions[key];

                            position[key] = {
                                yandex: {
                                    ctr: pos.ctr,
                                    clicks: pos.clicks,
                                    bid_price: pos.bid,
                                    shows: pos.shows,
                                    sum: pos.budget,
                                    amnesty_price: pos.budget / pos.clicks
                                }
                            };
                        });

                        position.requests = position.shows;
                    });

                    if (rData.error) {
                        notifyAboutForecastDataCalculationError();
                        alert(iget("Произошла ошибка. Попробуйте произвести расчет ещё раз."));

                        return;
                    }

                    afterForecastCalculationCheck();
                    notifyAboutForecastDataCalculationCompletion();
                    changeCurrencyTitles();

                    // minus words popup should be updated only after calculation is completed
                    model.update({
                        popup_minus_words: model.minus_words()
                    });

                    rData.unglued_keys = (rData.unglued_keys || []).concat(model.unglued_keys || []);
                    // the execution time of this statement should be measured
                    model.update(rData, $this);
                },
                timeout: AJAX_TIMEOUT_PERIOD
            });
        }

        /**
         * Рассчет суммы по параметрам с приведением amnesty_price к нормализованному
         * значению (делённое на 1e6 и округленное до двух знаков после запятой)
         * @param {Number} amnesty_price
         * @param {Number} clicks
         * @return {Number}
         */
        function calcSumByPriceAndClicks(amnesty_price, clicks) {
            return 1e6 * common.number.roundFormated(amnesty_price / 1e6, {fail: 0}) * clicks;
        }

        function afterForecastCalculationCheck() {
            submitButton.disabled = false;
            submitButton.value = iget('Пересчитать');
            $(phrasesTextarea).val("").change(); // триггерим change для DIRECT-13804 чтобы отработал обработчик
            noticeBefore.addClass('g-hidden');
            noticeAfter.removeClass('g-hidden');
        }


        function beforeForecastCalculationCheck() {
            submitButton.disabled = true;

            // phrase validation
            $doc.trigger('forecast-data.phrases_validation_started');
            if (!arePhrasesValid(phrases)) {
                notifyAboutForecastDataCalculationCompletion();

                submitButton.disabled = false;
                alert(phraseValidationMessage);
                phrasesTextarea.focus();

                return false;
            }

            // if it's the first time we got sums-clicks-shows calculated we should notify about this fact b-advanced-forecast__calculated-expense block
            if (!sumsClicksShowsAreCalculatedAtLeastOnce) {
                sumsClicksShowsAreCalculatedAtLeastOnce = true;
                $doc.trigger('forecast-data.calculated-for-the-first-time');
            }

            return true;
        }

        function notifyAboutForecastDataCalculationBegining() {
            submitButton.disabled = false;
            $doc.trigger('forecast-data.calculating_started');
        }
        function notifyAboutForecastDataCalculationError() {
            $doc.trigger('forecast-data.calculation_error');
        }
        function notifyAboutForecastDataCalculationCompletion() {
            $doc.trigger('forecast-data.calculating_finished');
        }

        function arePhrasesValid() {
            var phrases = getAllPhrases();
            if (phrases == "") return true;

            var result = common.validate.phrases(getAllPhrases(), getMinusWords());
            phraseValidationMessage = result.message;

            return result.valid;
        }

        function getInvalidKeyword() {
            var phrases = getAllPhrases().split(',');

            var result = "";
            for (var i = 0, l = phrases.length; i < l; i++) {
                if (!keywordsRE.test(phrases[i])) {
                    result = phrases[i];
                    return result;
                }
            }

            return result;
        }

        function isEmpty() {
            return (!getAllPhrases().length && !(model.text_rubrics &&  model.text_rubrics.length));
        }

        function changeCurrencyTitles() {
            currencyNodes.text(format_currency(model.forecastCurrency));
        }

    }
})(jQuery, window.Lego);
