(function($, Lego) {
    Lego.block['b-advanced-forecast__calculated-expense'] = function(params) {
        var $this = $(this),
            $doc = $(document),

            model = params.model,

            sliderFactor = null,
            isSliderFactorDefined = false,
            sliderContainer = $this.find(".js-slider-container"),
            slider = $this.find('.js-advanced-forecast-jquery-slider'),

            maxClicksValue= 0,
            minClicksValue = 0,

            isFirstForecastCalculated = false,
            budgetByPositionCalculated = false,

            amnestyPriceInput = $this.find('#js-advanced-forecast__calculated-amnesty_price'),
            sumInput = $this.find('#js-advanced-forecast__calculated-sum'),
            clicksInput = $this.find('#js-advanced-forecast__calculated-clicks'),

            inputValues = {
                'amnesty_price': amnestyPriceInput.val(),
                'sum': sumInput.val(),
                'clicks': clicksInput.val()
            },

            restrictions = {},

            sliderDelimeters = $this.find('.b-advanced-forecast__slider-delimeters'),
            sliderSteps = {
                amnestyPrice: sliderDelimeters.find('.b-advanced-forecast__slider-amnesty-price-value'),
                clicks: sliderDelimeters.find('.b-advanced-forecast__slider-click-value')
            },
            sliderHyphens = sliderDelimeters.children("li"),
            clicksSteps = [],
            amnestyPriceSteps = [],

            positions = direct.forecast.positions,
            position2position = direct.forecast.client_position2server_position;

        // triggred by `PhraseRow` when new position is set
        $doc
            .bind('new-position.phrase', onPhrasePositionChange)
            .bind('forecast-data.calculated-for-the-first-time', onForecastDataCalculatedForTheFirstTime)
            .bind('forecast-data.calculating_finished', onForecastDataCalculatingFinished)
            .bind('forecast-data.calculating_started', onForecastDataCalculatingStarted)
            .bind('forecast-data.phrases_validation_started', onPhrasesValidationStarted)
        // DIRECT-10886
            .bind('forecast-data.calculating_started', function(){ if (isDistributedBudgetMode()) budgetByPositionCalculated = false })

            .bind('forecast-type.budget-by-positions', function() {
                budgetByPositionCalculated = true;
                updateRestrictions('sum', model.sum);
            })
            .bind('calculate.forecast ' +
                  'forecast-type.distributed-budget ' +
                  'forecast-type.budget-by-positions',
                   function(e, restrictionsParams) {
                       if (isDistributedBudgetMode()) updateSliderSettings(true);
                       if (restrictionsParams) updateRestrictions(restrictionsParams.key, restrictionsParams.value);
                       calculateForecast();
                       if (restrictionsParams) model[restrictionsParams.key] = restrictionsParams.value;
                   });

        model
            .bind("change.restrictions", onRestrictionTypeChange)

        // when direct.forecast.Model.forecastParamsFields are changed
            .bind('change.forecast-params', onForecastParamsChange)
        // when entered phrases raw data is modified -- see `data_distributed` property of AJAX response
            .bind('change.raw_forecast_data', onEnteredPhrasesChange)
        // when default value of budget(sum) is changed
            .bind('change.rec_budget', onRecBudgetChange)
        // when restrictions are changed
            .bind('change.forecast-restrictions', onRestrictionsChange)
        // when all phrases are removed
            .bind('change.window_phrases', onWindowPhrasesChange)

            .bind('change.budget', onSummaryBudgetChange);

        // blur events for inputs trigger model updating
        amnestyPriceInput.blur(function(){ onBlurCheck('amnesty_price', this, 2, {min: 0.01, max: 50}); });
        sumInput.blur(function(){ onBlurCheck('sum', this, 2); });
        clicksInput.blur(function(){ onBlurCheck('clicks', this, 0); });
        function onBlurCheck(fieldKey, input, precision, restrictions) {
            var inputValue = common.number.clear(input.value, {fail: 0});
            if (inputValues[fieldKey] != inputValue) {
                inputValue = common.number.round(inputValue, {precision: precision, fail: 0});
                if (restrictions) {
                    inputValue = Math.max(restrictions.min, inputValue);
                    inputValue = Math.min(restrictions.max, inputValue);
                }
                inputValues[fieldKey] = inputValue;
                input.value = inputValue;

                // в расчетах используются данные не разделенные на 1000000
                // для этого значения 'sum', 'amnesty_price' введенные пользователем умножаем на 1е6
                updateRestrictions(
                    fieldKey,
                    ['sum', 'amnesty_price'].indexOf(fieldKey) > -1 ? inputValue * 1e6 : inputValue);

                calculateForecast();
                onRestrictionsChange();
            } else if (inputValues[fieldKey] != input.value) {
                //подставляем очищенное значение - например если было раньше 9.12, ввели 9.12blabla в input надо вернуть 9.12
                input.value = inputValue;
            }
        }

        //intercepting of 'enter' keydown
        var $form = $(amnestyPriceInput[0].form);
        $form.keydown(function(e){
            if (isTargetRestrictionInput(e.target) && e.keyCode == 13) {
                e.target.blur();
                return false;
            }

            function isTargetRestrictionInput(input) {
                if (input == amnestyPriceInput[0] || input == sumInput[0] || input == clicksInput[0]) return true;
                return false;
            }
        });

        slider.slider({
            min: 0,
            max: 300,
            change: function(e, ui) {
                if (!isSliderFactorDefined) return;

                var sliderClicksValue = parseInt(ui.value * sliderFactor, 10);
                var currentClicksValue = (sliderClicksValue > 0 && model.clicks < minClicksValue) ? minClicksValue : model.clicks;
                var clicksValue = (currentClicksValue < minClicksValue ? currentClicksValue : minClicksValue) + sliderClicksValue;
                clicksValue = !!maxClicksValue ? (clicksValue > maxClicksValue ? maxClicksValue : clicksValue) : clicksValue;

                updateRestrictions('clicks', clicksValue);
                calculateForecast();
            }
        });

        // clicks on slider hyphens should trigger forecast calculation as well
        $.each(sliderHyphens, function(index, item){
            $(item).click(function(){
                model.update({
                    clicks: clicksSteps[index]
                })
            })
        });

        function isDistributedBudgetMode() {
            return !!(FORECAST_MODE == DISTRIBUTED);
        }

        function onRestrictionTypeChange() {
            updateRestrictions(model.restrictions.type, model.restrictions.value);
        }

        function onWindowPhrasesChange() {
            var toBeEnabled = (model.window_phrases && model.window_phrases.length) ;
            toggleDisabling(!toBeEnabled);
        }

        function onPhrasesValidationStarted() {
            toggleDisabling(true);
        }

        function onForecastDataCalculatingStarted() {
            toggleDisabling(true);
        }

        function onForecastDataCalculatingFinished() {
            resetFlags();
            toggleDisabling();
        }

        function toggleDisabling(toBeDisabled) {
            sliderContainer.toggleClass("b-advanced-forecast__slider-disabled", toBeDisabled)
            slider.slider(toBeDisabled ? "disable" : "enable");

            amnestyPriceInput[0].disabled = toBeDisabled;
            sumInput[0].disabled = toBeDisabled;
            clicksInput[0].disabled = toBeDisabled;
        }

        function onForecastParamsChange() {
            isSliderFactorDefined = false;
            updateRestrictions('sum', model.sum);
            calculateForecast();
        }

        function resetFlags() {
            isSliderFactorDefined = false;
            isFirstForecastCalculated = false;
        }

        function onRecBudgetChange() {
            // recommended budget is taken into account unless budget position is calculated
            if (!isDistributedBudgetMode() || budgetByPositionCalculated) {
                onRestrictionsChange();
                return;
            }

            if (model.rec_budget > 0) {
                updateRestrictions('sum', model.rec_budget);
            } else {
                slider.slider("value", 0);
                updateRestrictions('clicks', clicksSteps[1]);
            }

            calculateForecast();
        }

        function onEnteredPhrasesChange(e) {
            // reseting slider related flags
            if (isDistributedBudgetMode()) {
                isSliderFactorDefined = false;
                sliderFactor = null;
            }

            // actually model has neither `current_phrases` fields
            // but i think it's better to trigger such events via model rather than, say, $(document).trigger(`event.name`);
            model
                .trigger('change.current_phrases', $this)

            if (isDistributedBudgetMode()) {
                if (!model.clicks && model.rec_budget) {
                    updateRestrictions('sum', model.rec_budget);
                } else {
                    updateRestrictions('clicks', model.clicks || 1000);
                }
            }
            calculateForecast();
            if (isDistributedBudgetMode()) updateSliderSettings();
        }

        function updateRestrictions(type, value) {
            restrictions = {type: type};
            restrictions[type] = value;
            model.restrictions = restrictions;
        }

        function getActivePhrases() {
            var activePhrases = {};
            if (!phrases) return activePhrases;

            for (var i = 0, l = window.phrases.length; i < l; i++) {
                if (phrases[i].isActive) activePhrases[phrases[i].key] = phrases[i].phrase;
            }

            return activePhrases;

        }

        function onSummaryBudgetChange() {
            if (isDistributedBudgetMode() || !model.sum) return;
            updateRestrictions('sum', model.sum);
        }

        function calculateForecast(keepCurrentRestrictions) {
            if (!isFirstForecastCalculated && !budgetByPositionCalculated) {
                restrictions = { type: 'unlim' };
            }

            var data = getForecastData();
            if (!data) return;

            var updateData = data.yandex;

            for (var key in data.total) {
                if (data.total.hasOwnProperty((key))) {
                    updateData[key] = data.total[key];
                }
            }

            updateData.amnesty_price = common.number.roundFormated(updateData.amnesty_price, {fail: 0});
            updateData.sum = common.number.roundFormated(updateData.sum, {fail: 0});

            updateData.clicks = common.number.roundFormated(updateData.clicks, {fail: 0, precision: 0});
            updateData.shows = common.number.roundFormated(updateData.shows, {fail: 0, precision: 0});

            model.update(updateData, $this);
            if (!isFirstForecastCalculated && isDistributedBudgetMode()) {
                isFirstForecastCalculated = true;
                updateSliderSettings();
                onRecBudgetChange();
            }

            $doc.trigger('calculate-forecast.finished');
        }

        function getForecastData() {
            switch(FORECAST_MODE) {
                case DISTRIBUTED: return getForecastDataForDistributedBudget();
                case BY_POSITIONS: return getForecastBudgetForBudgetByPositions();
            }
        }

        function getCurrentPositions() {
            if (isDistributedBudgetMode()) return {};

            var currentPositions = {},
                disabledPhrases = model.getDisabledPhrases();
            $.each(model.data_by_positions, function(index, item){
                if (item.md5 in disabledPhrases) return;

                var phraseType = 'phrases',
                    position = (model[phraseType] && model[phraseType][item.md5]) ? model[phraseType][item.md5].position : null;

                currentPositions[item.md5] = position2position[position || positions.FIRST_PLACE];
            });

            return currentPositions;
        }

        function getForecastBudgetForBudgetByPositions() {
            if (!model.data_by_positions) return;

            return {
                total: getTotalValuesByPositions(),
                yandex: getValuesByPositions()
            }
        }

        function onPhrasePositionChange() {
            common.func.debounce(function(){
                model.update(getTotalValuesByPositions())
            }, 50)();
        }

        function getTotalValuesByPositions(updatedData) {
            var totalValuesByPositions = { clicks: 0, shows: 0, requests: 0 },

                fields = model.phraseSumsByPositionsFields,
                sum_name2position = {
                    firstPremiumPosSum: direct.forecast.positions.FIRST_PREMIUM,
                    guaranteePosSum: direct.forecast.positions.GUARANTEE,
                    firstPlacePosSum: direct.forecast.positions.FIRST_PLACE,
                    premiumPosSum: direct.forecast.positions.PREMIUM
                },
                rawData = model.data_by_positions,
                disabledPhrases = model.getDisabledPhrases();

            window.showVCGAuction && (sum_name2position.secondPremiumPosSum = direct.forecast.positions.SECOND_PREMIUM);

            for (var i = 0, l = fields.length; i < l; i++) {
                (function(sumName){ totalValuesByPositions[sumName] = 0; })(fields[i]);
            }

            $.each(rawData, function(index, item){
                if (item.md5 in disabledPhrases) return;

                var modelItems = model['phrases'];
                var positionKey = direct.forecast.positions.FIRST_PLACE;
                if (modelItems && modelItems[item.md5] && modelItems[item.md5].position) {
                    positionKey = modelItems[item.md5].position;
                }
                var positionName = position2position[positionKey];

                totalValuesByPositions.clicks += parseInt(item[positionName]['yandex']['clicks'], 10);
                totalValuesByPositions.allPhrasesSum += parseFloat(item[positionName]['yandex']['sum'], 10);
                totalValuesByPositions.shows += parseFloat(item[positionName]['yandex']['shows'], 10);

                totalValuesByPositions.requests += parseInt(item.requests, 10);

                for (var i = 0, l = model.phraseSumsByPositionsFields.length; i < l; i++) {
                    (function(sumName){
                        if (!(sumName in sum_name2position)) return;
                        var position = position2position[sum_name2position[sumName]];
                        totalValuesByPositions[sumName] += parseFloat(item[position]['yandex']['sum'], 10);
                    })(model.phraseSumsByPositionsFields[i])
                }
            });

            totalValuesByPositions.sum = totalValuesByPositions.allPhrasesSum;

            return totalValuesByPositions;
        }

        function getValuesByPositions() {
            var rawData = model.data_by_positions,
                phrases = {},
                res = { phrases: {} },
                values = window.showVCGAuction ?
                    "clicks bid_price shows amnesty_price sum ctr".split(" ") :
                    "clicks amnesty_price shows sum ctr".split(" ");

            $.each(rawData, function(index, item){
                var valuesByPositions = (function(){
                    var result = {};

                    $.each(position2position, function(position, rawDataPosition){
                        $.each(values, function(i,value){
                            result[value] = result[value] || {};
                            result[value][position] = item[rawDataPosition]['yandex'][value];
                        });
                    });

                    result.requests = item.requests;
                    result.sign = item.sign;

                    return result;
                })();

                res['phrases'][item.md5] = valuesByPositions;
            });

            return res;
        }

        function getForecastDataForDistributedBudget() {
            if (!model.data_distributed) return;

            var disributedBudgetData = calc_advanced_forecast_p(
                    { data_distributed: model.data_distributed },
                    restrictions,
                    model.getForecastOptions()),

                // для колонки "Прогноз средней цены клика" решили выводить данные из
                // бюджета по позициям
                phrasesByPosition = window.showVCGAuction && getForecastBudgetForBudgetByPositions().yandex.phrases;

            window.showVCGAuction && Object.keys(disributedBudgetData.yandex.phrases).forEach(function(phraseKey) {
                var phrase = disributedBudgetData.yandex.phrases[phraseKey],
                    position = direct.forecast.server_position2client_position[phrase.position_2];

                phrase.bid_price = +phrasesByPosition[phraseKey].bid_price[position];
            });

            return disributedBudgetData;
        }

        function updateSliderSettings(forceUpdate) {
            if(isSliderFactorDefined && !forceUpdate) return;

            if (forceUpdate) sliderFactor = null;

            var max = slider.slider("option", "max");

            minClicksValue = getMinClicksValue();
            maxClicksValue = getMaxClicksValue();
            sliderFactor = sliderFactor || ((maxClicksValue - minClicksValue) / max);

            var clickStepValue = (maxClicksValue - minClicksValue) / 3;

            clicksSteps = [];
            amnestyPriceSteps = [];

            sliderSteps.clicks.each(function(index, item){
                var value = minClicksValue + index * clickStepValue;
                clicksSteps.push(value);
                amnestyPriceSteps.push(getAmnestyPriceValueBasedOnClicksValue(value));

                item.innerHTML = common.number.format(clicksSteps[index], {precision: 0});
            });

            sliderSteps.amnestyPrice.each(function(index, item){
                item.innerHTML = amnestyPriceSteps[index];
            });

            isSliderFactorDefined = true;
        }

        function getForecastWithoutModifyingRestrictions(restrictionType, value) {
            var oldRestrictions = restrictions;
            updateRestrictions(restrictionType, value);
            var data = getForecastData();
            restrictions = oldRestrictions;

            return data;
        }

        function getMaxClicksValue() {
            var data = getForecastWithoutModifyingRestrictions('unlim', 'unlim');
            return data.total.clicks ? parseInt(data.total.clicks, 10) : 0;
        }

        function getMinClicksValue() {
            var data = getForecastWithoutModifyingRestrictions('cent1', '0.01');

            return data.total.clicks ? parseInt(data.total.clicks, 10) : 0;
        }

        function getAmnestyPriceValueBasedOnClicksValue(clicksValue) {
            var amnestyPriceValue = formatValue(
                getForecastWithoutModifyingRestrictions('clicks', clicksValue).total.amnesty_price);

            return parseFloat(amnestyPriceValue, 10) > 0.01 ? amnestyPriceValue : 0.01;
        }

        function onRestrictionsChange() {
            if (!isDistributedBudgetMode()) return;

            var delimiter =  {exponent_delimiter: '' },
                sliderValue = (model.clicks - minClicksValue) / sliderFactor;

            amnestyPriceInput[0].value = inputValues['amnesty_price'] = formatValue(model.amnesty_price, delimiter);
            sumInput[0].value = inputValues['sum'] = formatValue(model.sum, delimiter);
            clicksInput[0].value = inputValues['clicks'] = model.clicks;

            slider.slider("value", sliderValue || 0);
        }

        function onForecastDataCalculatedForTheFirstTime() {
            $this.removeClass('g-hidden');
            $doc.trigger("calculated-expense.visible");
            common.ui.scrollToBlock($this);
        }

        /**
         * Делит переданное значение на 1e6 оставляя 2 дробных знака
         * Используется для форматирования значений которые приходят умноженными
         * на 1000000 для большей точности расчетов (amnesty_price, bid_price, sum)
         *
         * @param {Number} value
         * @param {Object} [options] параметры форматирования
         */
        function formatValue(value, options) {
            return common.number.format(value / 1e6, options);
        }

    }
})(jQuery, window.Lego);
