(function($, Lego) {
    Lego.block['b_advanced_forecast__excel-export'] = function(params) {

        var $this = $(this),
            model = params.model,
            $doc  = $(document),
            role = params.role || '',

            isClient = !!role.match('client'),
            isAgency = !!role.match('agency'),

            paramsTable = $this.find('.js-excel-export-params-table'),
            campaignNameRow = paramsTable.find('.js-campaign-name'),
            forecastTypeRow = paramsTable.find('.js-forecast-type'),
            exportForCampaign = paramsTable.find('.js-export-for-campaign'),

            campaignNameInput = paramsTable.find('input[name="campaign_name"]'),

            submitButton = paramsTable.find('.js-sumbit-button'),
            submitButtonMessage = paramsTable.find('.js-sumbit-button-msg'),

            paramsToBeShownInExcel = paramsTable.find('.js-params-to-be-shown-in-excel'),
            ctrControls = paramsToBeShownInExcel.find('.js-ctr-controls'),
            selectedPositionsControls = paramsToBeShownInExcel.find('.js-selected-positions-controls'),
            firstPremiumControls = paramsToBeShownInExcel.find('.js-first-premium-controls'),
            secondPremiumControls = window.showVCGAuction ? paramsToBeShownInExcel.find('.js-second-premium-controls') : null,
            premiumControls = paramsToBeShownInExcel.find('.js-premium-controls'),
            firstPlaceControls = paramsToBeShownInExcel.find('.js-first-place-controls'),
            guaranteeControls = paramsToBeShownInExcel.find('.js-guarantee-controls'),

            dayCheckbox = forecastTypeRow.find('.js-day-checkbox'),
            weekCheckbox = forecastTypeRow.find('.js-week-checkbox'),
            monthCheckbox = forecastTypeRow.find('.js-month-checkbox'),

            checkboxes = paramsTable.find('input[type="checkbox"]').map(function(i, checkbox){
                return {
                    name: checkbox.getAttribute('name'),
                    domElement: checkbox
                }
            }),

            hiddenForm = null;

        exportForCampaign.change(function(){ // (DIRECT-12696) дизейблим все остальные чекбоксы, если этот будет выбран
            var _this = this,
                checked = exportForCampaign.prop('checked');
            forecastTypeRow.add(paramsToBeShownInExcel).find('input').each(function(i, el){
                $(el).prop('disabled', checked)
            })
        });

        var pricePlaces = window.CONSTS.PRICE_PLACES,
            entryPlaces = window.CONSTS.ENTRY_PLACES,
            newname2oldname = {
            'day_forecast'              : ['show_period', 'day'],
            'week_forecast'             : ['show_period', 'week'],
            'month_forecast'            : ['show_period', 'month'],
            'ctr'                       : ['show_plan', 'ctr'],
            'selected_positions'        : ['show_plan', 'select'],
            'first-premium_positions'   : ['show_plan', pricePlaces.PREMIUM1],
            'second-premium_positions'  : ['show_plan', pricePlaces.PREMIUM2],
            'premium_positions'         : ['show_plan', entryPlaces.PREMIUM],
            'first-place_positions'     : ['show_plan', pricePlaces.GUARANTEE1],
            'guarantee_positions'       : ['show_plan', entryPlaces.GUARANTEE],
            'export_for_campaign'       : ['export_for_campaign', '1']
        };

        var positionCheckboxes = ['selected_positions', 'first-premium_positions', 'second-premium_positions', 'premium_positions', 'first-place_positions', 'guarantee_positions'];

        bindEventHandlers();
        initUIControls();
        syncWithModel();

        function syncWithModel() {
            onForecastPeriodTypeChange();
            onForecastTypeChange();
        }

        function initUIControls() {
            if ($.trim(campaignNameInput.val()).length == 0) {
                campaignNameInput.val(iget('Новая'));
            }

            $.each(checkboxes, function(i, checkboxObj){
                if (($.inArray(checkboxObj.name, params.showInForecast) > -1) || checkboxObj.name == 'day_forecast') {
                    checkboxObj.domElement.checked = true;
                }
            });

            if (isClient || isAgency) {
                // DIRECT-14815 для агентств не скрываем строки: "Отображать прогноз" и "CTR"
                enableBlock(isAgency ? campaignNameRow : campaignNameRow.add(forecastTypeRow).add(ctrControls), false);
            }

        }

        function bindEventHandlers() {
            $doc
                .bind('export2xls.toggle', toggleBlock)
                .bind('forecast-type.budget-by-positions forecast-type.distributed-budget', onForecastTypeChange);

            campaignNameInput.focus(function(){ this.select(); });
            submitButton.click(exportToExcel);

            model
                .bind('change.forecastPeriodType', onForecastPeriodTypeChange)
                .bind('change.window_phrases', onWindowPhrasesChange)
        }

        function onWindowPhrasesChange() {
            var toBeDisabled = model.areAllPhrasesDisabled();

            submitButton.prop('disabled', toBeDisabled);
            submitButtonMessage
                    .toggleClass('g-hidden', !toBeDisabled)
                    .text(iget('Выберите хотя бы одну фразу для экспорта в XLS'));
        }

        function onForecastTypeChange() {
            var isBudgetByPositionsMode = !isDistributedBudgetMode();

            enableBlock(forecastTypeRow, isBudgetByPositionsMode);

            var paramsToBeToggled = secondPremiumControls ?
                selectedPositionsControls
                    .add(firstPremiumControls)
                    .add(secondPremiumControls)
                    .add(firstPlaceControls)
                    .add(guaranteeControls)
                    .add(premiumControls) :
                selectedPositionsControls
                    .add(firstPremiumControls)
                    .add(firstPlaceControls)
                    .add(guaranteeControls)
                    .add(premiumControls);

            enableBlock(paramsToBeToggled, isBudgetByPositionsMode);
        }

        function enableBlock(block, toBeEnabled) {
            block
                .toggle(toBeEnabled)
                .find('input').each(function(index, input){
                    input.disabled = !toBeEnabled;
                })
        }

        function onForecastPeriodTypeChange() {
            if (!isDistributedBudgetMode()) {
                var isForecastForMonth = model.forecastPeriodType == 'month',
                    isForecastForWeek = model.forecastPeriodType == 'week';

                enableBlock(weekCheckbox, isForecastForMonth && !isForecastForWeek);
                enableBlock(monthCheckbox, !isForecastForMonth && !isForecastForWeek);
            }
        }

        function toggleBlock() {
            $this.toggleClass('g-hidden');
        }

        function getCampaignName() {
            return campaignNameInput.val();
        }

        function validateParams() {
            if (isDistributedBudgetMode()) return true;

            var result = false;

            $.each(checkboxes, function(i, checkboxObj){
                if (($.inArray(checkboxObj.name, positionCheckboxes) > -1) && checkboxObj.domElement.checked) {
                    result = true;
                }
            });

            if (!result) {
                alert(iget("Нужно выбрать объём трафика для экспорта!"));
            }

            return result;
        }

        function exportToExcel() {
            if (!validateParams()) return;

            var form = getHiddenForm().attr('action', 'forecast.' + Math.floor(10000 * Math.random()) + '.xls'),
                expData = model.exportData();

            addHiddenInput(form, 'cmd', 'advancedBudgetForecast');
            addHiddenInput(form, 'campaign_name', getCampaignName());


            $.each(expData, function(key, value){
                addHiddenInput(form, key, value);
            });

            // export to xls params
            $.each(checkboxes, function(i, checkboxObj){
                var checkbox = checkboxObj.domElement,
                    checkboxName = checkboxObj.name;

                if (!checkbox.checked || checkbox.disabled) return;

                addHiddenInput(form, newname2oldname[checkboxName][0], newname2oldname[checkboxName][1]);
            });

            form[0].submit();
        }

        function addHiddenInput($form, name, value) {
            if (value == null) return;

            var form = $form[0];
            var input = document.createElement('input');

            input.name = name;
            input.setAttribute('type', 'hidden');
            input.value = value;

            form.appendChild(input);
        }

        function getHiddenForm() {
            if (hiddenForm) return hiddenForm.empty();

            hiddenForm = $('<form></form>').attr('method', 'POST');
            document.body.appendChild(hiddenForm[0]);

            return hiddenForm;
        }

        function isDistributedBudgetMode() {
            return !!(FORECAST_MODE == DISTRIBUTED);
        }
    }
})(jQuery, window.Lego);

