FORECAST_MODE = '';
BY_POSITIONS = 'budget-by-positions';
DISTRIBUTED = 'distributed-budget';

(function($, Lego) {
    Lego.block['b-advanced-forecast__expense-tabs'] = function(params) {

        var $this = $(this),
            $doc = $(document),
            model = params.model,
            tabsBlock = $this.children('.js-tabs-block'),
            tabsContentContainer = $this.find('.js-tabs-content-container'),
            tabsContent = $this.find('.js-tabs-content'),
            errorMessage = $this.find('.js-error-message'),
            budgetByPositionsMessageTemplate = $this.find('.js-budget-by-positions-msg-template').html(),
            budgetByPositionsMessageNode = $this.find('.js-budget-by-positions-msg');

        budgetByPositionsMessageNode.html(budgetByPositionsMessageTemplate);

        tabsBlock.bind('b-tabs.changed', function(e, data){
            onBudgetTypeChange(data.name);
        });

        $doc
            .bind('forecast-data.phrases_validation_started', function(){
                if (isByPositionsMode()) toggleLoadingLayerForTabsContent(true);
            })
            .bind('forecast-data.calculation_error', function(){
                errorMessage.removeClass('g-hidden');
                tabsContent.addClass('g-hidden');
                if (isByPositionsMode()) toggleLoadingLayerForTabsContent(false);
            })
            .bind('forecast-data.calculating_finished', function(){
                tabsContent.removeClass('g-hidden');
                errorMessage.addClass('g-hidden');
                if (isByPositionsMode()) toggleLoadingLayerForTabsContent(false);
            });

        model.bind('change.phrase-sum-by-positions change.forecastCurrency', onPhraseSumByPositionsChange);

        function onBudgetTypeChange(budgetType, noCustomEvent) {
            window.FORECAST_MODE = budgetType;
            if (!noCustomEvent) {
                $doc.trigger('forecast-type.' + budgetType);
            }
        }
        
        function onPhraseSumByPositionsChange() {
            var templateData = {};
            $.each(model.phraseSumsByPositionsFields, function(i, sumName){
                templateData[sumName] = common.number.format(model[sumName] / 1e6);
            });

            templateData.currency = format_currency(model.forecastCurrency);

            budgetByPositionsMessageNode.html(direct.utils.supplant(budgetByPositionsMessageTemplate, templateData));
        }

        function isByPositionsMode() {
            return !!(FORECAST_MODE == BY_POSITIONS);
        }

        function toggleLoadingLayerForTabsContent(showLoadingLayer) {
            tabsContentContainer.toggleClass("b-advanced-forecast__tabs_content_container__loading", showLoadingLayer);
        }
    }
})(jQuery, window.Lego);
