(function($, Lego) {
    Lego.block['b-advanced-forecast__forecast-params'] = function(params) {
        var $this = $(this),
            changeParamsLink = $this.find('.b_advanced_forecast__forecast_params__change_link'),

            popup = $('#' + params.popupId),
            model = params.model;

        var forecastPeriod = $this.find('.js-forecast-period'),
            forecastPlatform = $this.find('.js-forecast-platform'),
            forecastCurrency = $this.find('.js-forecast-currency');

        var hiddenInputs = {
            'forecastPeriodType' : $this.find('.js-hidden-forecast-period-type'),
            'forecastPeriod' : $this.find('.js-hidden-forecast-period'),
            'forecastPlatform' : $this.find('.js-hidden-forecast-platform'),
            'forecastCurrency' : $this.find('.js-hidden-forecast-currency')
        };

        update();
        model.bind('change', onModelChange);
        changeParamsLink.click(onChangeParamsLinkClick);

        function onModelChange(e) {
            if (e.source === $this) { return; }

            updateTexts();
            updateHiddenInputs();
        }

        function update() {
            updateTexts();
            updateHiddenInputs();
        }

        function updateTexts() {
            forecastPeriod.text(model.getMessage('forecastPeriod'));
            forecastPlatform.text(model.getMessage('forecastPlatform'));
            forecastCurrency.text(get_currency(model.forecastCurrency).full_name);
        }

        function updateHiddenInputs() {
            for (var fieldName in hiddenInputs) {
                hiddenInputs[fieldName].val(model[fieldName]);
            }
        }

        function onChangeParamsLinkClick(event) {
            event.preventDefault();
            if (popup.data('api').visible()) {
                popup.data('api').close();
            } else {
                $(document).trigger('b-window_close-all');
                popup.removeClass('g-hidden').data('api').open();
            }
        }

    }
})(jQuery, window.Lego);
