(function($, Lego) {
    Lego.block['b-advanced-forecast__forecast-params__popup'] = function(params) {
        var $this = $(this),
            popup = $this.find('.b-window'),
            model = params.model,
            periodSelectboxesRow = $this.find('.js-forecast-period-selectboxes');

        var controls = {
            forecastPeriodType: {
                nodes: $this.find('input[name="forecast-period-type"]'),
                type: 'radio',
                onChange: onPeriodTypesRadioButtonsChange
            },
            forecastPeriod: {
                nodes: $this.find('select[name="forecast-period"]'),
                type: 'select'
            },
            forecastPlatform: {
                nodes: $this.find('select[name="forecast-platform"]'),
                type: 'select'
            },
            forecastCurrency: {
                nodes: $this.find('select[name="forecast-currency"]'),
                type: 'select'
            }
        };

        model.bind('change', onModelChange);

        popup
            .bind('b-window_open', onModelChange)
            .bind('b-window_submit', onSubmit);

        //binding onChange handlers
        for (var controlKey in controls) {
            var control = controls[controlKey];
            control.nodes.each(function(i, node){
                if ($.isFunction(control.onChange)) {
                    $(node).bind('change', control.onChange);
                }
            });
        }

        function onModelChange(e) {
            if (e.source === $this) { return; }
            if (!e.changes) { updateAllFields(); return; }

            for (var controlKey in e.changes) {
                if (e.changes.hasOwnProperty(controlKey) && controls[controlKey]) {
                    updateControl(controlKey);
                    controls[controlKey].onChange();
                }
            }
        }

        function updateControl(controlKey) {
            var control = controls[controlKey],
                controlType = control.type,
                modelValue = model[controlKey];

            if (!control) return;

            switch (controlType) {
                case 'checkbox':
                    control.nodes.each(function(i, checkbox){
                        checkbox.checked = !!modelValue;
                    });
                    break;
                case 'select':
                    control.nodes.each(function(i, select){
                        select.value = modelValue;
                        if ('minValue' in control) select.value = (modelValue < control.minValue) ? control.minValue : modelValue;
                    });
                    break;
                case 'radio':
                    control.nodes.each(function(i, radio){
                        radio.checked = !!(radio.value == modelValue);
                    });
                    break;
            }
            if ($.isFunction(control.onChange)) {
                control.onChange();
            }
        }

        function updateAllFields() {
            for (controlKey in controls) {
                updateControl(controlKey);
            }
        }

        function onPeriodTypesRadioButtonsChange(e) {
            var radio = controls.forecastPeriodType.nodes.filter(function(){ return this.checked; });
            radio = radio.length ? radio : controls.forecastPeriodType.nodes.filter(function(){ return this.value == model.forecastPeriodType ; });
            radio = radio[0];
            radio.checked = true;

            if (radio.value == 'year') {
                periodSelectboxesRow.css("visibility", "hidden");
                controls.forecastPeriod.nodes.each(function(i, selectbox){
                    selectbox.disabled = true;
                })
            } else {
                controls.forecastPeriod.nodes.each(function(i, selectbox) {
                    var toBeDisabled = !(selectbox.className.match(radio.value));
                    selectbox.disabled = toBeDisabled;
                    selectbox.style.display = toBeDisabled ? 'none' : '';
                    selectbox.selectedIndex = 0;
                });
                periodSelectboxesRow.css("visibility", "visible");
            }
        }

        function onSubmit() {
            var data = {};

            for (var controlKey in controls) {
                var control = controls[controlKey],
                    nodes = control.nodes,
                    controlValue = null;

                switch (control.type) {
                    case 'checkbox':
                        nodes.each(function(i, checkbox){
                            if (!checkbox.disabled) {
                                controlValue = this.checked ? 1 : 0;
                            }
                        });
                        break;
                    case 'select':
                        nodes.each(function(i, select){
                            if (!select.disabled) {
                                controlValue = select.value;
                            } else if (controlKey != 'forecastPeriod') {
                                controlValue = select.value;
                                //controlValue = control.minValue || 0;
                            }
                        });
                        break;
                    case 'radio':
                        var checkedRadio = nodes.filter(function(){ return this.checked; });
                        if (checkedRadio.length && !checkedRadio[0].disabled) {
                            controlValue = checkedRadio[0].value;
                        }
                        break;
                }

                data[controlKey] = controlValue;
            }

            model.update(data, $this);
        }

    }
})(jQuery, window.Lego);
