(function($, Lego) {
    Lego.block['b_advanced_forecast__minus-words'] = function(params) {

        var $this = $(this),
            model = params.model,
            $doc = $(document),
            textarea = $this.find('.b-validator__minus-words__input'),
            toggleLink = $this.find('.js-toggle-link'),
            textareaContainer = $this.find(".js-textarea-container");

        $doc.bind('forecast-data.calculating_finished', function(){
            if ($.trim(textarea.val()).length == 0) textareaContainer.addClass("g-hidden");
        });


        onMinusWordsChange();

        model.bind('change.minus_words', onMinusWordsChange);
        model.bind('change.popup_minus_words', onPopupMinusWordsChange);

        toggleLink.click(function(){
            textareaContainer.toggleClass("g-hidden");
        });

        textarea.bind('change keyup click blur', function(){
            model.update({
                '_minus_words': textarea[0].value
            })
        });

        function onMinusWordsChange() {
            textarea.val(model.minus_words());
            textareaContainer.toggleClass("g-hidden", !textarea.val().length);
        }

        function onPopupMinusWordsChange() {
            model.update({
                '_minus_words': BEM.blocks['i-utils'].normalizeMinusWordsString(model.minus_words())
            });
        }

    }
})(jQuery, window.Lego);
