var FIRST_PREMIUM_POS = direct.forecast.positions.FIRST_PREMIUM;
var SECOND_PREMIUM_POS = direct.forecast.positions.SECOND_PREMIUM;
var PREMIUM_POS = direct.forecast.positions.PREMIUM;
var FIRST_PLACE_POS = direct.forecast.positions.FIRST_PLACE;
var GUARANTEE_POS = direct.forecast.positions.GUARANTEE;
var NON_GUARANTEE_POS = direct.forecast.positions.NON_GUARANTEE;
var CENT1_POS = direct.forecast.positions.CENT1;
var $doc = $(document);

window.hellipCutLength = 50;

var PhraseRow = function(key, phrase, template, model) {
    var that = this;

    this.model = model;
    this.key = key;
    this.phrase = $.trim(phrase);
    this.cssClassForSingeValueElementWrapper = "js-wrapper-for-single-value";
    this.requests  = null;
    this.position = null;
    this.isVisible  = false;
    this.isChecked = false;
    this.bid_price = null;
    this.amnesty_price = null;
    this.clicks = null;
    this.shows  = null;
    this.budget = null;
    this.ctr    = null;

    this.createNode(template);

    common.func.defer(function(){
        that.initEditablePhrase();
        that.bindEventHandlers();
    })
};

PhraseRow.prototype = {

    emptyValue: function() {
        return FORECAST_MODE == 'budget-by-positions' ? '0' : '\u2014';
    },

    getJQueryNode: function() {
        return this.$node || (this.$node = $(this.node));
    },

    createNode: function(template) {
        var phr = this.phrase,
            rowHTML = direct.utils.supplant(template, {
                phraseKey: this.key,
                phrase: direct.utils.escapeHTML(phr),
                collapsedPhrase: direct.utils.hellipCut(phr, hellipCutLength),
                // для правки DIRECT-13560 (про ошибку в ИЕ9)
                // из-за бажности innerHTML в IE (см. http://stackoverflow.com/questions/1231770/innerhtml-removes-attribute-quotes-in-internet-explorer)
                // для ИЕ ставим не пустую строку на строку с двойными кавычками
                collapsedPhraseTitle: phr.length > hellipCutLength ? direct.utils.escapeHTML(phr) : $.browser.msie ? '""' : ''
            }),
            depth = 2,
            div = document.createElement('div');

        div.innerHTML = "<table><tbody>" + rowHTML + "</tbody></table>";
        while ( depth-- ) {
            div = div.lastChild;
        }
        this.node = div.childNodes[0];
    },

    getPositionsNodes: function() {
        if (!this.positions) {
            var that = this;
            this.positions = (function(){
                var result = {};
                var positionsMap = direct.forecast.positions;
                for (var key in positionsMap) {
                    var pos = positionsMap[key];
                    result[pos] = that.getJQueryNode().find('.js-' + pos + '-pos');
                }
                return result;
            })();
        }
        return this.positions;
    },

    getUIElementsWithSingeValue: function() {
        return this.uiElementsWithSingeValue ||
                (this.uiElementsWithSingeValue = this.getJQueryNode().find('.js-ui-elements-for-single-value'));
    },

    getUIElementsByPositons: function() {
        return this.uiElementsByPositons ||
                (this.uiElementsByPositons = this.getJQueryNode().find('.js-ui-elements-by-positions'));
    },

    getRadioButtonsForPositions: function() {
        return this.radioButtonsForPositions ||
                (this.radioButtonsForPositions = this.getRadioButtonsByPositionsContainer().find("input[name='position-type-" + this.key + "']"));
    },

    getRadioButtonsByPositionsContainer: function() {
        return this.radioButtonsByPositionsContainer ||
                (this.radioButtonsByPositionsContainer = this.getJQueryNode().find('.js-radio-buttons-by-positions'));
    },

    getValueCellsForPositions: function() {
        if (!this.valueCellsForPositions) {
            var that = this;
            this.valueCellsForPositions = {};

            var values = window.showVCGAuction ?
                    ['clicks', 'ctr', 'sum', 'bid_price', 'shows', 'amnesty_price'] :
                    ['clicks', 'ctr', 'sum', 'shows', 'amnesty_price'],
                positions = window.showVCGAuction ?
                    [FIRST_PLACE_POS, FIRST_PREMIUM_POS, SECOND_PREMIUM_POS, GUARANTEE_POS, PREMIUM_POS] :
                    [FIRST_PLACE_POS, FIRST_PREMIUM_POS, GUARANTEE_POS, PREMIUM_POS];

            for (var i = 0, l = values.length; i < l; i++ ) {
                (function(value){
                    var container = that.getJQueryNode().find(".js-" + value + "-values-by-positions");
                    for (var j = 0, k = positions.length; j < k; j++) {
                        (function(positionName){
                            that.valueCellsForPositions[positionName] = that.valueCellsForPositions[positionName] || {};
                            that.valueCellsForPositions[positionName][value] = container.find(".js-" + positionName + "-pos > span.js-value");
                        })(positions[j])
                    }
                })(values[i])
            }

        }

        return this.valueCellsForPositions;
    },

    initEditablePhrase: function() {
        var that = this;
        // initializing of this.editablePhrase
        Lego.blockInit(this.node, ".b-editable-text");
        // callbacks to this block are passed dynamically
        this.editablePhrase().data('callbacks', $.extend(this.editablePhrase().data('callbacks'), {
            submit: function(newPhrase) { that.changePhrase(newPhrase); },
            beforeSubmit: function(newPhrase) { return that.validatePhrase(newPhrase); }
        }));
    },

    bindEventHandlers: function() {
        var that = this;

        this.selectPhraseLink().click(function(){ that.showSelectPhrasePopup() });
        this.checkbox()
            .change(function(){ that.toggleCheck(this.checked) })
            .click(function(){ that.onCheckBoxClick() });
        this.specifyPhraseLink().click(function() { that.showSpecifyPhraseLinkPopup() });
        this.showOtherBannersLink().click(function() { that.showOtherBannersPopup() });
        this.editPhraseLink().click(function() { that.editPhrase() });
        this.removePhraseLink().click(function(e) { e.preventDefault(); that.removePhrase() });
        this.getRadioButtonsForPositions().change(function(){
            var radio = that.getRadioButtonsForPositions().filter(function(){ return this.checked });
            that.setPositionForBudgetByPositions(radio[0].value);
        })
    },

    onCheckBoxClick: function() {
        $doc.trigger("clicked-checkbox.phrase", [this.isChecked, this.key]);
    },

    showSelectPhrasePopup: function() {
        if (!this.isActive()) return;

        var WordsStatForm = document.forms['WordsStat'];

        if (!WordsStatForm) return;

        WordsStatForm.phrase_num_from_forecast.value = this.getWindowPhrasesIndex();
        WordsStatForm.text.value = this.phrase;
        WordsStatForm.geo.value = this.model.getGeoId();

        var popup = common.ui.openPopup("", 800, 600, "Words");
        WordsStatForm.submit();
        popup.focus();
    },

    showSpecifyPhraseLinkPopup: function() {
        if (!this.isActive()) return;

        var WordMinusForm = document.forms['WordsMinus'];

        if (!WordMinusForm) return;

        WordMinusForm.phrase_num_from_forecast.value = this.key;
        WordMinusForm.text.value = this.phrase;
        WordMinusForm.geo.value = this.model.getGeoId();
        WordMinusForm.minus_words.value = BEM.blocks['i-utils'].minusWordsStringToArray(this.model._minus_words).join(',');

        var popup = common.ui.openPopup("", 800, 600, "Words");
        WordMinusForm.submit();
        popup.focus();
    },

    toggleUIElementsForBudgetByPositions: function(toBeShown) {
        if (this.uiElementsForBudgetByPositionsVisible == toBeShown) return;

        this.uiElementsForBudgetByPositionsVisible = toBeShown;

        this.toggleVisibility(false);

        var that = this;
        $.each(this.getUIElementsByPositons(), function(){ this.style.display = toBeShown ? '' : 'none'; });
        $.each(this.getRadioButtonsByPositionsContainer(), function(){ this.style.display = toBeShown ? '' : 'none'; });
        $.each(this.getRadioButtonsForPositions(), function(){ this.disabled = that.isChecked ? !toBeShown : true });

        $.each(this.getUIElementsWithSingeValue(), function(){ this.style.display = toBeShown ? 'none' : ''; });
        $.each(this.wrappersForElementsWidthSingeValue(), function(){
            this.style.display = toBeShown ? 'none' : '';
            this.className = that.cssClassForSingeValueElementWrapper + (toBeShown ? '' : ' active');
        });

        this.toggleVisibility(true);
    },

    getWindowPhrasesIndex: function() {
        var index = -1,
            phraseKey = this.key;

        if (!window.phrases || !window.phrases.length) return index;

        for(var i = 0, l = window.phrases.length; i < l; i++) {
            if (window.phrases[i]['key'] == phraseKey) {
                index = i;
                break;
            }
        }

        return index;
    },

    removePhrase: function(bulkAction) {
        if (!bulkAction) {
            if (!confirm(this.removePhraseLink().attr("confirm-message"))) {
                return;
            }
        }
        // do not remove node -- otherwise all event hanslers are removed as well
        // and the node is not capable of being reinserted into DOM later on.
        this.getJQueryNode().detach();
        this.isAppended = false;

        this.toggle(false);
        this.toggleCheck(false, true);

        if (!bulkAction) {
            $doc.trigger('removed.phrase', [this.key]);
        }

    },

    getPhraseWithoutMinusWords: function() {
        var result = this.phrase.match(/^.+?(?=\s\-)/);
        return this.phraseWithoutMinusWords = result ? result[0] : this.phrase;
    },

    changePhrase: function(newPhrase) {
        if (newPhrase == this.phrase) return;
        this.setPhrase(newPhrase);
        $doc.trigger("changed.phrase", [this.key]);
    },

    setPhrase: function(newPhrase) {
        this.phrase = newPhrase;
        this.phraseWithoutMinusWords = this.getPhraseWithoutMinusWords();
        this.phraseCell()
            .text(direct.utils.hellipCut(newPhrase, hellipCutLength))
            .attr('title', newPhrase.length > hellipCutLength ? direct.utils.escapeHTML(newPhrase) : '')
            .data('api').params.phrase = newPhrase;

    },

    isActive: function() {
        return this.isVisible && this.isChecked;
    },

    validatePhrase: function(phrase) {
        var validationResult = common.validate.phrases(phrase);
        if (!validationResult.valid) alert(validationResult.message);

        return validationResult.valid;
    },

    editPhrase: function() {
        if (!this.isActive()) return;

        this.editablePhrase().data('api').edit();
    },

    showOtherBannersPopup: function() {
        if (!this.isActive()) return;

        common.ui.openPopup(SCRIPT + "?cmd=showCompetitors&phrase=" + this.getPhraseWithoutMinusWords() + '&geo=' + encodeURIComponent(this.model.getGeoId()), 700, 600, "advancedForecastOtherBanners");
    },

    updateValueCellsByForPositions: function(valueName, valuesByPositions, precision) {
        var that = this,
            valueCellsForPositions = this.getValueCellsForPositions();

        $.each(valuesByPositions, function(positionName, value){
            valueCellsForPositions[positionName][valueName].text(that._formatValue(value, precision, valueName));
        });
    },

    setValue: function(valueKey, singleValueCellName, value) {
        var val,
            precision = !!valueKey.match(/clicks|shows|requests/) ? 0 : 2;

        if (typeof value == 'object') {
            val = value;
            this.updateValueCellsByForPositions(valueKey, value, precision);
        } else {
            val = this._formatValue(value, precision, valueKey);
            $.each(this[singleValueCellName](), function(){
                this.innerHTML = val;
            })
        }

        this[valueKey] = val;

        return this;
    },

    setPositionForBudgetByPositions: function(positionName) {
        this.resetHighlighting();
        this.togglePositionHighlighting(positionName);

        //@heliarian - чтобы повторно не устанавливать позицию
        if (this.position !== positionName) {
            //@heliarian при удалении фраза не удаляется из хэша, а при переименовании - дублируется
            //чтобы не переписывать весь код - добавляем проверки this.isAppended && this.isVisible
            if (!this._isDataUpdating && this.isAppended && this.isVisible && this.isChecked) {
                window.logInfoDebonce({ position: positionName, phrase: this.phrase });
            }
        }

        this.position = positionName;

        $doc.trigger("new-position-event", [this.position, this.key]);

        var radio = this.getRadioButtonsForPositions().filter(function(){ return this.value == positionName; });
        if (radio.length) radio[0].checked = true;

        this.notifyAboutNewPosition();
    },

    notifyAboutNewPosition: function() {
        $doc.trigger("new-position.phrase");
    },

    setPosition: function(firstPosition, secondPosition) {
        if (arguments.length == 0) {
            this.setPositionForBudgetByPositions(this.position || FIRST_PLACE_POS);
            return;
        }

        this.resetHighlighting();

        for (var i = 0, l = arguments.length; i < l; i++) {
            var serverPosKey = arguments[i];
            var positionName = direct.forecast.server_position2client_position[serverPosKey];
            if (!!positionName && !!positionName.length && this.getPositionsNodes()[positionName]) {
                this.togglePositionHighlighting(positionName, true);
            } else if (!!serverPosKey && !!serverPosKey.match(NON_GUARANTEE_POS + "|" + CENT1_POS)) {
                this.togglePositionHighlighting(NON_GUARANTEE_POS, true);
            }
        }
    },

    isEmpty: function() {
        if (!this.model.isDistributedBudgetMode()) {
            return false;
        }

        var values = window.showVCGAuction ?
                "ctr sum shows clicks bid_price amnesty_price".split(" ") :
                "ctr sum shows clicks amnesty_price".split(" "),
            isEmpty = false;

        for (var i = 0, l = values.length; i < l; i++) {
            var value = this[values[i]];
            if (value == this.emptyValue()) {
                isEmpty = true;
            }
        }

        return isEmpty;
    },

    resetHighlighting: function() {
        var _this = this;
        $.each(this.getPositionsNodes(), function(key){
            _this.togglePositionHighlighting(key, false);
        });
    },

    togglePositionHighlighting: function(positionName, toBeHighlighted) {
        this.getPositionsNodes()[positionName].toggleClass('active', toBeHighlighted);
    },

    toggleVisibility: function(toBeShown) {
        this.node.style.display = toBeShown ? '' : 'none';
    },

    updateData: function(data){
        this.toggleVisibility(false);
        this._isDataUpdating = true;

        this
            .setValue('sum', 'budgetCell', data.sum)
            .setValue('shows', 'showsCell', data.shows)
            .setValue('clicks', 'clicksCell', data.clicks)
            .setValue('requests', 'requestsCell', data.requests);

        window.showVCGAuction && this.setValue('bid_price', 'bid_priceCell', data.bid_price);

        this.setValue('amnesty_price', 'amnesty_priceCell', data.amnesty_price)
            .setValue('ctr', 'ctrCell', data.ctr || (data.shows ? (data.clicks/data.shows) * 100 : 0));

        if (typeof data.clicks == 'object') {
            this.setPosition();
        } else {
            this.setPosition(data.position_1, data.position_2);
        }

        this._isDataUpdating = false;
        this.toggleVisibility(true);

        return this;
    },

    setEmpty: function() {
        var data = {
            ctr: 0,
            sum: 0,
            shows: 0,
            clicks: 0,
            requests: 0,
            amnesty_price: 0
        };

        window.showVCGAuction && (data.bid_price = 0);

        this.updateData(data);
    },

    setLowCtr: function(isLowCtr) {
        this.lowCtrIcon().attr("style", !isLowCtr ? "display: none;" : "");
    },

    toggle: function(toBeShown) {
        if (toBeShown != this.isVisible) {
            this.isVisible = toBeShown;
            this.node.style.display = toBeShown ? "" : "none";
        }

        return this;
    },

    toggleCheck: function(toBeSelected, isPhraseDeleted, isInit) {
        this.getJQueryNode().toggleClass("b-advanced-forecast__disabled-phrase", !toBeSelected);
        var isDistributedMode = model.isDistributedBudgetMode();
        $.each(this.getRadioButtonsForPositions(), function(){
            this.disabled = isDistributedMode ? true : !toBeSelected;
        });
        this.checkbox()[0].checked = toBeSelected;

        if (this.isChecked != toBeSelected || isInit) {
            this.isChecked = toBeSelected;
            this._triggerToggleCheckEvents(toBeSelected, isPhraseDeleted);
        }
    },

    _triggerToggleCheckEvents: function(toBeSelected, isPhraseDeleted) {
        if (!isPhraseDeleted) $doc.trigger(toBeSelected ? "checked.phrase" : "unchecked.phrase");
        $doc.trigger("toggled.phrase", [this.isChecked, this.key]);
    },

    _formatValue: function(value, precision, name, undefined) { // на всякий случай экранируем undefined
        if (['bid_price', 'amnesty_price', 'sum'].indexOf(name) > -1) {
            // для большей точности расчета значения приходят не отформатированными
            // по этому при выводе делим значение на 1000000
            value /= 1e6;
        }

        return !!parseFloat(value) ?
            common.number.format(value, precision === undefined ? {} : { precision: +precision }) :
            this.emptyValue();
    },

    constructor: PhraseRow

};

(function(proto){

        /**
         * hash for creating elements getters
         * key -> `methodName`
         * value -> css selector template used to find the certain child within the phrase row node
         *
         * The main reason all these mehtods are created in a such manner is just
         * the neccesity to make PhraseRow as fast as possible.
         * This approach brings the opportunity to miss parsing phrase row node at initialization stage.
         *
         * TODO:
         * At the moment all subclasses of PhraseRow should add all required 'methodName -> selectorTemplate' pairs
         * to this hash. Later on, it's supposed to be refactored so that all subclasses getters are defined in
         * the corresponding class
         *
         */
        var map = {
                "checkbox":                             "#{phraseKey}-toggle-phrase",
                "amnesty_priceCell":                    "#{phraseKey}-js-amnesty_price-value",
                "ctrCell":                              "#{phraseKey}-js-ctr-value",
                "clicksCell":                           "#{phraseKey}-js-clicks-value",
                "budgetCell":                           "#{phraseKey}-js-sum-value",
                "phraseCell":                           ".js-phrase-cell",
                "requestsCell":                         ".js-requests-cell",
                "showsCell":                            "#{phraseKey}-js-shows-value",
                "wrappersForElementsWidthSingeValue":   "#{phraseKey}-wrapper-for-single-value",
                "lowCtrIcon":                           "#{phraseKey}-low-ctr-icon",
                "editablePhrase":                       "#{phraseKey}-b-editable-text",
                "showOtherBannersLink":                 "#{phraseKey}-b-editable-text",
                "editPhraseLink":                       "#{phraseKey}-change-phrase",
                "specifyPhraseLink":                    "#{phraseKey}-specify-phrase",
                "selectPhraseLink":                     "#{phraseKey}-select-phrase",
                "removePhraseLink":                     "#{phraseKey}-remove-phrase",
                "bid_priceCell":                        "#{phraseKey}-js-bid_price-value",
                "positionsList":                        "#{phraseKey}-js-positions-list"
            },
            cachedElements = {};

        for (var key in map) {
            (function(methodName, selector){
                proto[methodName] = function(){
                    var elements = this.key + '-' + methodName + "-Nodes";
                    return cachedElements[elements] ||
                            (cachedElements[elements] = this.getJQueryNode().find(selector.replace(/{phraseKey}/gi, this.key)));
                }
            })(key, map[key]);
        }

})(PhraseRow.prototype);
