
(function($){

var ajaxUrl = '/registered/main.pl',
    cacheAge, //сохраненное значение для восстановления метки
    request,
    VARIANTS = [ 0, 6, 12, 16, 18 ],
    LABEL_TEXT_INSTALL = iget('Добавить возрастное ограничение'),
    LABEL_TEXT_UNINSTALL = iget('Снять возрастное ограничение'),
    LABEL_TEXT_ERROR = iget('Произошла ошибка при изменении возрастного ограничения!');

BEM.DOM.decl('b-age-label', {
    onSetMod : {
        js: function() {

            cacheAge = this.params.age;
            if (cacheAge == -1) cacheAge = 18;
            this.model =  BEM.blocks['i-models-manager'].get(this.params.modelPath, 'b-banner-edit')
                .onField('age', 'change', this.onExternalChange, this);

            this.popup = this.findBlockInside('b-dropdowna').getPopup();
            this.displayLabel = this.elem('display-label');
            this.spin = this.elem('spin');

            request = BEM.create('i-request_type_ajax', {
                url: ajaxUrl,
                cache: false,
                dataType: 'json',
                onError: function () {
                    alert(LABEL_TEXT_ERROR);
                }
            });

            this
                .bindTo('link', 'click', function() {
                    var installed = this.getMod('installed') != 'no';

                    this.setAge(installed ? -1 : cacheAge);
                })
                .bindTo('item', 'click', function(e) {
                    var age = this.findBlockInside(e.data.domElem, 'b-pseudo-link').params.age;

                    if (age != cacheAge)
                        this.setAge(age);

                    this.popup.hide();
                });
        },

        installed: function(modName, modVal){
            this.elem('link').html(modVal == 'no' ? LABEL_TEXT_INSTALL : LABEL_TEXT_UNINSTALL);
        }
    },

    _onSaveAge: function(age) {
        if ( age > -1 )  {
            this.displayLabel.html(age + '+').attr('title', age + '+');
            cacheAge = age;
            this.setMod('installed', 'yes');
        } else
            this.setMod('installed', 'no');
    },

    onExternalChange: function(e, data) {
        if (data.source == this) return;

        this._onSaveAge(this.model.get('age'));
    },

    /*
    * Установка возрастного ограничения
    * @param {Number} age Возраст. Если == -1, значит добавляется дефолтный возраст (блок показывается)
    * @param {Function} callback нужен для смены значения гарантировано после успешного запроса
    */
    setAge: function(age) {

        if (age != -1) cacheAge = age;

        //если передали -1 и блок скрыт, значит хотим включить блок
        if (age == -1 && this.getMod('installed') == 'no')
            age = cacheAge;

        this.model.set('age', age, this);

        this.setMod(this.spin, 'show', 'yes');

        request.get({
            flag: 'age=' + age,
            csrf_token: window.csrf_token,
            cmd: 'changeFlagsAjax',
            bid: this.model.get('bid')
        }, function (result) {
                this.delMod(this.spin, 'show');

                if ( result && result.success ) {
                    this._onSaveAge(age);
                } else
                    alert(LABEL_TEXT_ERROR);
            },
            {
                callbackCtx: this
            }
        );
    }
});

BEM.HTML.decl('b-age-label', {

    onBlock: function(ctx) {
        var age = ctx.param('age'),
            variants = ctx.param('variants') || VARIANTS,
            canToggle = ctx.param('canToggle'),
            variantsContent = [];

        //age может быть равен 0!
        if (typeof age == 'undefiend')
            age = -1;

        /*
        Создаем контент с элементами b-menu, которые будут в b-dropdown
        b-menu в тт2 неправильно строится, поэтому тут хаки и много лишних оберток
        TODO После нормализации b-menu поправить здесь элементы
        */
        for (var i = 0; i < VARIANTS.length; i++)
            variantsContent.push({
                elem: 'layout-vert-cell',
                tag: 'li',
                content: {
                    block: 'b-pseudo-link',
                    mix: [ { block: 'b-age-label', elem: 'item' } ],
                    js: { age: VARIANTS[i] },
                    content: VARIANTS[i] + '+'
                }
            });

        ctx
            .js(true)
            .mods((age == -1) && { installed: 'no' })
            .content([
                {
                    elem: 'panel',
                    content: [
                        {
                            elem: 'display-label',
                            attrs: { title: age + '+' },
                            content: age + '+'
                        },
                        {
                            block: 'b-dropdowna',
                            mix: [ { block: 'b-age-label', elem: 'dropdowna' } ],
                            mods: { 'is-bem': 'yes' },
                            content: [
                                {
                                    block: 'b-dropdowna',
                                    elem: 'switcher',
                                    tag: 'span',
                                    content: {
                                        block: 'b-pseudo-link',
                                        mods: { 'is-bem': 'yes' },
                                        content: iget('изменить')
                                    }
                                },
                                {
                                    block: 'b-popupa',
                                    mix: [ { block: 'b-age-label', elem: 'popup' } ],
                                    content: [
                                        { elem: 'tail' },
                                        {
                                            elem: 'content',
                                            content: {
                                                block: 'b-menu',
                                                mods: { layout: 'vert', preset: 'vmenu' },
                                                content: {
                                                    elem: 'layout-vert',
                                                    tag: 'ul',
                                                    content: variantsContent
                                                }
                                            }
                                        }
                                    ]
                                }
                            ]
                        },
                        {
                            //TODO поменять после DIRECT-20037
                            block: 'b-question-mark',
                            elem: 'small',
                            mix: [ { block: 'b-age-label', elem: 'help-link' } ],
                            tag: 'a',
                            attrs: {
                                href: get_help_url('age-restriction'),
                                onclick: 'OpenWindow(this.href,700,400); return false;'
                            },
                            content: '<img alt="" src="/i/icons/question.gif">'
                        },
                        {
                            block: 'b-spin',
                            mix: [ { block: 'b-age-label', elem: 'spin' } ],
                            mods: { size: 10 }
                        }
                    ]
                },
                canToggle && {
                    block: 'b-pseudo-link',
                    mix: [ { block: 'b-age-label', elem: 'link' } ],
                    content: age < 0 ? LABEL_TEXT_INSTALL : LABEL_TEXT_UNINSTALL
                }
            ]);
    },

    onElem: {

        'elem': function(ctx) {
            ctx
                .content(iget('Адрес и телефон'));
        }

    }

});


})(jQuery);
