(function($){
    var iModelsManager = BEM.blocks['i-models-manager'],
        request;

    BEM.DOM.decl('b-age-labels-multiedit', {
        onSetMod: {
            'js': function(){
                var _this = this;

                this.popupa = this.findBlockOutside('b-popupa');
                this.cancelBtn = this.findBlockInside('cancel', 'b-form-button')
                    .on('click', this.onCancel, this);

                this.acceptBtn = this.findBlockInside('accept', 'b-form-button')
                    .on('click', this.onAccept, this);

                this.models = [];

                $.each(this.params.bids, function(i, bid){
                    var model = iModelsManager.get('campaign&banner:' + bid, 'b-banner-edit');

                    if (model.get('age_enabled')) {
                        _this.models.push(model);
                    }
                });

                request = BEM.create('i-request_type_ajax', {
                    cache: false,
                    url: '/registered/main.pl',
                    dataType: 'json',
                    callbackCtx: this,
                    type: 'post'
                });
            }
        },

        onCancel: function() {
            this.popupa.hide();
        },

        onAccept: function() {
            var age = this.elem('radio:checked').val(),
                pids = this.models.map(function(model) {
                    return model.get('pid');
                });

            request.get(
                {
                    cmd: 'changeGroupFlagsAjax',
                    pid: pids.join(','),
                    flag: 'age=' + age
                },
                function() {
                    $.each(this.models, function(i, model) {
                        model.set('age', age, this);
                    });

                    this.popupa.hide();
                }
            );
        }
    });

    BEM.HTML.decl('b-age-labels-multiedit', {

        onBlock: function(ctx){
            ctx
                .js(true)
                .content({ elem: 'form', cid: ctx.param('cid'), bids: ctx.param('bids') });
        },

        onElem: {

            'form': function(ctx){
                ctx
                    .content(
                    [
                        {
                            tag: 'h2', content:
                            [
                                {
                                    tag: 'span',
                                    content: iget('Изменить возрастное<br/> ограничение')
                                },
                                {
                                    tag: 'a',
                                    elem: 'help',
                                    cls: 'b-question-mark',
                                    attrs: {
                                        onclick: 'OpenWindow(this.href,700,450); return false;',
                                        title: iget('Помощь'),
                                        href: get_help_url('age-restriction'),
                                        target: '_blank'
                                    },
                                    content: {
                                        tag: 'img',
                                        attrs: {src: '/i/icons/question.gif'}
                                    }
                                }
                            ]
                        },
                        {
                            tag: 'div',
                            elem: 'comment',
                            content:  iget('Изменение будет применено только к объявлениям с доступным возрастным ограничением')
                        },

                        {
                            tag: 'div',
                            elem: 'comment',
                            content:  iget('Выбрано объявлений') + ': ' + ctx.param('bids').length
                        }


                    ]
                        .concat(
                        $.map(['cid', 'bids'], function(el){
                            return { tag: 'input', attrs: { type: 'hidden', name: el, value: ctx.param(el) } }
                        }),
                        { elem: 'container' },
                        { elem: 'errors' },
                        { elem: 'accept' }, { elem: 'cancel' }
                    )
                )
            },

            'container': function(ctx) {
                //todo прокинуть AD_WARNINGS.age.variants
                var content = [];
                $.each([18, 16, 12, 6, 0], function(i, age) {
                    content.push({
                        elem: 'age-item',
                        content: [
                            {
                                tag: 'input',
                                attrs: {'type': 'radio', value: age, id: 'age_multiedit_' + age, name: 'age_multiedit'},
                                elem: 'radio'
                            },
                            {
                                tag: 'label',
                                content: age + '+',
                                elem: 'label',
                                attrs: {'for': 'age_multiedit_' + age}
                            }
                        ]
                    })
                });

                ctx.content(content);
            },

            'accept': function(ctx){
                ctx
                    .tag('span')
                    .content({
                        block: 'b-form-button',
                        mods: { valign: 'middle' },
                        type: 'button',
                        content: iget('Сохранить')
                    })
            },
            'cancel': function(ctx){
                ctx
                    .tag('span')
                    .content({
                        block: 'b-form-button',
                        mods: { valign: 'middle' },
                        type: 'button',
                        content: iget('Отмена')
                    })
            }
        }

    });


})(jQuery);
