(function($, Lego) {
    Lego.block['b-acr-edit'] = function(params) {

        var form ={
            el : {
                root            : 'b-acr-edit',
                field           : 'b-acr-edit__field',
                idSelectfield   : 'b-acr-edit__field#application_id_select',
                idInputfield    : 'b-acr-edit__field#application_id_input',
                siteInputfield  : 'b-acr-edit__field#company_site',
                fieldRequired   : 'b-acr-edit__field-required',
                fieldContainer  : 'b-acr-edit__fieldcontainer',
                fieldWithExtra  : 'b-acr-edit__field-withextra',
                fieldExtra      : 'b-acr-edit__field_extra',
                fileField       : 'b-acr-edit__file',
                fileItem        : 'b-acr-edit__filelist-itm',
                extraBlock      : 'b-acr-edit__extrablock',
                statusTxt       : 'b-acr-edit__statustxt',
                error           : 'b-acr-edit__field-error',
                invalid         : 'b-acr-edit__field-invalid',
                loading         : 'b-acr-edit__field-loading',
                deleteFile      : 'b-acr-edit__deletefile',
                attach          : 'b-acr-edit__fileattach',
                removeFilefield : 'b-acr-edit__removefilefield',
                addFilefield    : 'b-acr-edit__addfield',
                tooltipToggler  : 'b-acr-tooltip__toggler',
                tooltipData     : 'b-acr-tooltip__data'
            },

            cls : function(cl) { return '.'+form.el[cl] },
            node: function(cl) { return $(form.cls(cl)) }
        };

        $(this)
            .on('keypress', form.cls('field')          , protectForm)
            .on('change'  , form.cls('idSelectfield')  , toggleAppIdInput)
            .on('change'  , form.cls('idSelectfield')  , checkID)
            .on('blur'    , form.cls('idInputfield')   , checkID)
            .on('blur'    , form.cls('siteInputfield') , checkHref)
            .on('click'   , form.cls('addFilefield')   , addFileField)
            .on('change'  , form.cls('fieldWithExtra') , toggleExtraInput)
            .on('click'   , form.cls('deleteFile')     , deleteFile)
            .on('click'   , form.cls('removeFilefield'), removeFileField)
            .on('click'   , form.cls('tooltipToggler') , toggleTooltip)
            .on('click'   , form.cls('tooltipData') , function(e){
                e.stopPropagation();
            })
            .on('submit'  , checkForm);

        $('body').on('click', function(e) {

            form.node('tooltipData').hide();
        });

        onInit();

        function onInit() {

            toggleAppIdInput.call($('[name=application_id]'));

            form.node('fieldExtra').each(function(){
                toggleExtraInput.call($(this));
            })

            checkID.call($('#application_id_select') || $('#application_id_input'));

            $('[name=dev_finish]').datePicker({ clickInput: true });

        };

        function toggleTooltip(e) {
            var el = $(this).next(form.cls('tooltipData'));

            e.stopPropagation();

            form.node('tooltipData').not(el).hide();
            el.fadeToggle();
        };

        function protectForm() {

            window.onbeforeunload = function() {
                return iget('Эта страница просит вас подтвердить, что вы хотите уйти — при этом введённые вами данные могут не сохраниться.')
            }
        };

        function checkForm(e) {
            window.onbeforeunload = false;

            var allFields = form.node('field'),
                fields = form.node('fieldRequired').find(form.cls('field')).filter(':visible'),
                regs = {
                    tags  : new RegExp(/[<\=()>\"]/ig),
                    email : new RegExp(/^\S+@\S+\.\S+$/),
                    url   : new RegExp(/(?:https?:\/\/)?(www\.)?[-a-zA-Z0-9@:%._\+~#=]{2,256}\.[a-z]{2,6}\b([-a-zA-Z0-9@:%_\+.~#?&//=]*)/gi),
                    number: new RegExp(/^[0-9]+$/ig)
                },
                status = { valid: {}, invalid: {} };

            allFields.filter('.b-acr-edit-textarea, b-acr-edit-input').each(function() {
                var safeVal = $(this).val().replace(regs.tags, '');
                $(this).val(safeVal);
            });

            fields.each(function(i) {
                var $this = $(this),
                    name = $this.attr('name'),
                    cont = $this.parents(form.cls('fieldContainer')),
                    rule = cont.data('rule'),
                    val = $this.val(),
                    isVal = val;

                if ($this.attr('type') == 'radio' || $this.attr('type') == 'checkbox' ){
                    isVal = $this.is(':checked');
                } else {
                    var parts = val.split(',');

                    if(parts.length){

                        $.each(parts, function(i, str){
                            if(rule){
                                return isVal = $.trim(str).match(regs[rule]);
                            }
                        });

                    } else {
                        isVal = false;
                    }
                }

                if(!isVal || cont.is(form.cls('error'))){
                    if(!status.valid[name]){
                        status.invalid[name] = this;
                    }
                } else {
                    status.valid[name] = this;
                    delete status.invalid[name];
                }
            });

            $.each(status.valid, function() {
                changeField.call( this, 'reset');
            });

            $.each(status.invalid, function() {

                var cont = $(this).closest(form.cls('fieldContainer')),
                    txt = cont.find(form.cls('statusTxt')).text() || cont.data('msg');

                changeField.call( this, 'invalid', txt);
            });

            if (!$.isEmptyObject(status.invalid)) {
                e.preventDefault();
                alert(iget('Не все поля заполнены корректно'));
            }
        };

        function appendStatusTxt(txt) {

            var container = $(this).closest(form.cls('fieldContainer')),
                msg = txt || container.data('msg') || iget('Ошибка');

            if (!container.find(form.cls('statusTxt')).length){
                container.append('<div class="'+form.el.statusTxt+'">'+msg+'</div>')
            } else {
                container.find(form.cls('statusTxt')).text(msg)
            }
        };

        function addFileField(param) {

            var newAttachHTML = '<div class="'+form.el.fieldContainer+'" '+
                                        'data-msg="'+iget('Приложите файлы со спецификациями и скриншотами и заполните описания')+'">'+
                                        '<div class="'+form.el.field+' '+form.el.fieldRequired+' '+ form.el.attach +'" >';

            if(param !== 'hide_remove'){
                newAttachHTML += '<span class="'+form.el.removeFilefield+'">&times;</span>';
            }

            newAttachHTML += '<input class="'+form.el.field+' b-acr-edit__field b-acr-edit__file" '+
                                     'type="file" name="specifications_and_screenshots_names['+ form.node('attach').length +']">'+
                                '<label class="b-acr-edit__label b-acr-edit__label_tall">'+iget("Опишите файл")+'</label>'+
                                '<textarea class="'+form.el.field+' b-acr-edit__field b-acr-edit__textarea" rows="2" '+
                                           ' name="specifications_and_screenshots_descriptions['+ form.node('attach').length +']"></textarea>'+
                            '</div></div>';

            var newAttach = $(newAttachHTML);

            newAttach
                .find('input, textarea')
                .removeAttr('value');

            $(this).before(newAttach.slideDown('fast'));

            if(form.node('attach').length == 2){
                form.node('attach').first().append('<span class="'+form.el.removeFilefield+'">&times;</span>');
            }


        };

        function removeFileField() {




            $(this)
                .closest(form.cls('fieldContainer'))
                .slideUp('fast', function() {
                    $(this).remove();



                    form.node('attach').each(function(i) {
                        $(this).find('input, textarea').each(function() {
                            var name = $(this).attr('name');
                            $(this).attr({
                                name: name.replace(/(\d+)/, i)
                            })
                        });
                    });

                    if(params.type == 'add' && form.node('attach').length < 2){
                        form.node('attach').first().find(form.cls('removeFilefield')).remove();
                    }

                    if(params.type == 'edit' && !form.node('fileItem').length && form.node('attach').length < 2){
                        form.node('attach').first().find(form.cls('removeFilefield')).remove();
                    }

                });
        };

        function deleteFile() {

            var root = $(this).parent(),
                appId = form.node('root').data('appid');

            confirm(iget('Удалить файл?')) && $.ajax({
                type: 'GET',
                url: 'main.pl?cmd=ajaxApiCertificationDeleteFile',
                dataType: 'json',
                data: {
                    name : root.data('name'),
                    application_id : appId
                },

                success: function(data) {
                    root.slideUp('fast', function() {
                        if(form.node('fileItem').length === 1){
                            addFileField.call(
                                $(this)
                                    .closest(form.cls('fieldContainer'))
                                    .find(form.cls('addFilefield')),

                                'hide_remove'
                            );

                            $(this).parent().remove();

                        } else {
                            $(this).remove();
                        }

                    })
                }
            });
        };

        function checkID() {

            var node = $(this),
                val = node.val();

            if (val){
                $.ajax({
                    type: 'GET',
                    url: 'main.pl?cmd=ajaxApiCertificationValidateId',
                    dataType: 'json',
                    data: {
                        application_id : val
                    },

                    beforeSend: function() {
                        changeField.call( node, 'loading', iget('проверка ID ...'));
                    },

                    success: function(data) {
                        var errs = data.errors,
                            isValid = !errs.length,
                            errTxt = !isValid ? errs.shift().pop() : '';

                        if(isValid){
                            changeField.call( node, 'reset');
                            changeField.call( node, 'no-error');
                        } else {
                            changeField.call( node, 'error', errTxt);
                        }


                    }
                });
            } else {
                changeField.call( node, 'reset');
            }
        };

        function checkHref() {

            var node = $(this),
                cont = node.closest(form.cls('fieldContainer')),
                val = node.val();

            val ? cont.addClass(form.el.fieldRequired) : cont.removeClass(form.el.fieldRequired);


        };

        function changeField(st, txt, field) {

            var node = field || $(this),
                cont = node.closest(form.cls('fieldContainer')),
                cls = [form.el.error, form.el.invalid, form.el.loading];

            cont.removeClass([form.el.invalid, form.el.loading].join(' '));
            node.removeAttr('disabled');

            if(st == 'reset'){
                cont.find(form.cls('statusTxt')).remove();
            } else if(st == 'no-error'){
                cont.removeClass(form.el.error);
            }else {
                cont.addClass(form.el[st]);
                txt && appendStatusTxt.call(node, txt);
                (st == 'loading') && node.attr('disabled' , 'disabled');
            }
        };

        function toggleExtraInput() {

            var $this = $(this),
                extraField = $this.siblings(form.cls('extraBlock')),
                term = $this.is(form.cls('fieldExtra')+':checked');

            if ($this.is('.b-acr-edit__checkbox')){
                var field = $this.is(form.cls('fieldExtra')) ? $this : $this.siblings(form.cls('fieldExtra'));
                term = field.is(':checked');
            }

            term ? extraField.css('display', 'inline-block') : extraField.hide();
        };

        function toggleAppIdInput() {

            var select = $(this),
                input = $('#application_id_input');

            if($(this).val() ){
                select
                    .attr('name', $(this).attr('name') || $(this).attr('data-name')).removeAttr('data-name')
                    .parents(form.cls('fieldContainer'))
                    .addClass(form.el.fieldRequired)

                input
                    .attr('data-name' , $(this).attr('name')).removeAttr('name')
                    .parents(form.cls('fieldContainer'))
                    .removeClass('invalid field-required').hide()

            } else {

                changeField.call(input, 'reset');

                select
                    .attr('data-name',  $(this).attr('name')).removeAttr('name')
                    .parents(form.cls('fieldContainer'))
                    .removeClass([form.el.fieldRequired, form.el.error].join(' '))

                input
                    .attr('name', $(this).attr('data-name')).removeAttr('data-name').focus()
                    .parents(form.cls('fieldContainer'))
                    .addClass(form.el.fieldRequired).show()
            }

        };
    }
})(jQuery, window.Lego);
