(function($, Lego) {
    Lego.block['b-acr-list'] = function() {

        var list = {
            el : {
                listDropToggle      : 'b-acr-list__dropdown-btn',
                listDropList        : 'b-acr-list__dropdown-list',
                listItemList        : 'b-acr-list__items',
                listItem            : 'b-acr-list__item',
                listDelItem         : 'b-acr-list__itmedelete',
                listItemCtrl        : 'b-acr-list__itemctr',
                listItemHistory     : 'b-acr-list__itemhistory',
                listItemHistoryList : 'b-acr-list__itemhistorylist',
                listItemHistoryBtn  : 'b-acr-list__itemhistorybtn',
                listItemChSt        : 'b-acr-list__itmeachangest',
                listItemChStComment : 'b-acr-list__itmeachangest-textarea',
                listItemChStPopup   : 'b-acr-list__itmeachangest-popup',
                listItemChStProceed : 'b-acr-list__itmeachangest_proceed',
                listItemChStAbort   : 'b-acr-list__itmeachangest_abort'
            },
            cls : function(cl) { return '.'+this.el[cl] },
            node: function(cl) { return $(this.cls(cl)) }
        };

        $('body').on('click', function() {
            list.node('listDropList').hide();
            list.node('listItemHistoryList').hide();
            list.node('listItemHistoryBtn').removeClass('expand');
        });

        $(this)
            .on('click', list.cls('listDropToggle')     , toggleDropdown)
            .on('click', list.cls('listDelItem')        , deleteItem)
            .on('click', list.cls('listItemChSt')       , toggleChangeStatusForm)
            .on('click', list.cls('listItemChStAbort')  , hideChangeStatusForm)
            .on('click', list.cls('listItemChStProceed'), proceedChangeStatusRequest)
            .on('click', list.cls('listItemHistoryBtn') , toggleHistoryList)


        function toggleDropdown(e) {

            var el = $(this).next(list.cls('listDropList'));

            e.stopPropagation();

            list.node('listDropList').not(el).hide();
            el.toggle();
        };

        function toggleHistoryList(e) {

            var btn = $(this),
                hlist = btn.next(list.cls("listItemHistoryList"));

            e.stopPropagation();

            list.node("listItemHistoryList").not(hlist).hide();
            list.node('listItemHistoryBtn').not(btn).removeClass('expand');

            btn.toggleClass('expand');
            hlist.slideToggle('fast');
        };

        function toggleChangeStatusForm() {

            var id = $(this).data('appid'),
                action = $(this).data('action'),
                popup = list.node('listItemChStPopup').filter('[data-appid='+id+']');

            list.node('listItemChStPopup').not(popup).hide();

            popup.data('action', action).toggle();
        };

        function changeStatus (st, appid, ulogin, callback) {

            $.ajax({
                type: 'GET',
                url: 'main.pl?cmd=ajaxApiCertificationSetStatus',
                dataType: 'json',
                data: {
                    application_id : appid,
                    status : st,
                    ulogin : ulogin
                },
                success: function(data) {
                    typeof callback == 'function' && callback(data);
                }
            });
        };

        function addComment (txt, appid, ulogin, callback) {

            $.ajax({
                type: 'GET',
                url: 'main.pl?cmd=ajaxApiCertificationAddComment',
                dataType: 'json',
                data: {
                    application_id : appid,
                    comment : txt,
                    ulogin : ulogin
                },
                success: function(data) {
                    typeof callback == 'function' && callback(data);
                }
            });
        };

        function proceedChangeStatusRequest() {

            var popup = $(this).parents(list.cls('listItemChStPopup')),
                comment = popup.find(list.cls('listItemChStComment'));

            if(comment.val()){
                $.ajax({
                    type: 'GET',
                    url: 'main.pl?cmd=ajaxApiCertificationAddComment',
                    dataType: 'json',
                    data: {
                        application_id : popup.data('appid'),
                        comment : comment.val(),
                        ulogin : popup.data('ulogin')
                    },
                    success: function(data) {

                        $.ajax({
                            type: 'GET',
                            url: 'main.pl?cmd=ajaxApiCertificationSetStatus',
                            dataType: 'json',
                            data: {
                                application_id : popup.data('appid'),
                                status : popup.data('action'),
                                ulogin : popup.data('ulogin')
                            },
                            success: function(data) {
                                popup.fadeOut();
                                window.location.reload();
                            }
                        })
                    }
                });
            } else {
                alert(iget('Введите текст коментария'));
            }
        };

        function hideChangeStatusForm() {

            $(this).parents(list.cls('listItemChStPopup')).hide();
        };

        function deleteItem() {

            var item = $(this).closest(list.cls('listItem'))

            confirm(iget('Удалить заявку?')) && $.ajax({
                type: 'GET',
                url: 'main.pl?cmd=ajaxCertificationDeleteRequest',
                dataType: 'json',
                data: {
                    application_id : item.data('appid')
                },
                success: function(data) {
                    if( list.node('listItem').length > 1){
                        item.animate({
                            opacity: 0,
                            height:  0
                        }, 500, function(){
                            $(this).remove()
                        })
                    } else {
                        item.fadeOut('fast',function() {
                            $(this).replaceWith(iget('Список пуст'));
                        })

                    }

                }
            });
        };
    }
})(jQuery, window.Lego);
