(function($, Lego) {
    Lego.block['b-acr-show'] = function() {

        var show = {
            el : {
                itemHistoryList : 'b-acr-show__itemhistorylist',
                itemHistoryBtn  : 'b-acr-show__itemhistorybtn',
                itemChSt        : 'b-acr-show__itmeachangest',
                itemChStComment : 'b-acr-show__itmeachangest-textarea',
                itemChStPopup   : 'b-acr-show__itmeachangest-popup',
                itemChStProceed : 'b-acr-show__itmeachangest_proceed',
                itemChStAbort   : 'b-acr-show__itmeachangest_abort'
            },
            cls : function(cl) { return '.'+this.el[cl] },
            node: function(cl) { return $(this.cls(cl)) }
        };

        $('body').on('click', function() {
            show.node('itemHistoryList').hide();
            show.node('itemHistoryBtn').removeClass('expand');
        });

        $(this)
            .on('click', show.cls('itemHistoryBtn'), toggleHistoryList)
            .on('click', show.cls('itemChSt'), toggleChangeStatusForm)
            .on('click', show.cls('itemChStAbort'), hideChangeStatusForm)
            .on('click', show.cls('itemChStProceed'), proceedChangeStatusRequest)


        function hideChangeStatusForm() {

            $(this).parents(show.cls('itemChStPopup')).hide();
        };

        function toggleHistoryList(e) {

            var btn = $(this),
                hlist = btn.next(show.cls("itemHistoryList"));

            e.stopPropagation();

            show.node("itemHistoryList").not(hlist).hide();
            show.node('itemHistoryBtn').not(btn).removeClass('b-acr-show__expand');

            btn.toggleClass('b-acr-show__expand');
            hlist.slideToggle('fast');
        };

        function toggleChangeStatusForm() {

            var id= $(this).data('appid'),
                action = $(this).data('action'),
                popup = show.node('itemChStPopup').filter('[data-appid='+id+']');

            show.node('itemChStPopup').not(popup).hide();

            popup.data('action', action).toggle();
        };

        function changeStatus (st, appid, ulogin, callback) {

            $.ajax({
                type: 'GET',
                url: 'main.pl?cmd=ajaxApiCertificationSetStatus',
                dataType: 'json',
                data: {
                    application_id : appid,
                    status : st,
                    ulogin : ulogin
                },
                success: function(data) {
                    typeof callback == 'function' && callback(data);
                }
            })

        };

        function addComment (txt, appid, ulogin, callback) {

            $.ajax({
                type: 'GET',
                url: 'main.pl?cmd=ajaxApiCertificationAddComment',
                dataType: 'json',
                data: {
                    application_id : appid,
                    comment : txt,
                    ulogin : ulogin
                },
                success: function(data) {
                    typeof callback == 'function' && callback(data);
                }
            })

        };

        function proceedChangeStatusRequest() {

            var popup = $(this).parents(show.cls('itemChStPopup')),
                comment = popup.find(show.cls('itemChStComment'));

            if(comment.val()){

                $.ajax({
                    type: 'GET',
                    url: 'main.pl?cmd=ajaxApiCertificationAddComment',
                    dataType: 'json',
                    data: {
                        application_id : popup.data('appid'),
                        comment : comment.val(),
                        ulogin : popup.data('ulogin')
                    },
                    success: function(data) {

                        $.ajax({
                            type: 'GET',
                            url: 'main.pl?cmd=ajaxApiCertificationSetStatus',
                            dataType: 'json',
                            data: {
                                application_id : popup.data('appid'),
                                status : popup.data('action'),
                                ulogin : popup.data('ulogin')
                            },
                            success: function(data) {
                                popup.fadeOut();
                                window.location.reload();
                            }
                        })
                    }
                })

            } else {
                alert(iget('Введите текст коментария'));
            }
        };
    };
})(jQuery, window.Lego);
